{# twig vars #}
{# options #}
{% set labelHtmlTag = label_html_tag %}
{% set prefixTextValue = prefix|raw %}
{% set sufixTextValue = suffix|raw %}
{% set minDefaultRangeValue = minimum_default_range %}
{% set maxDefaultRangeValue = maximum_default_range %}
{% set showValuesBelowSlider = show_values_below_slider %}
{% set rangeValuePosition = range_value_position %}
{% set showPrefix = show_prefix %}
{% set showSufix = show_suffix %}
{% set minimumValue = minimum_value %}
{% set maximumValue = maximum_value %}

{# classes #}
{% set ueNumInputWrapperClass = "ue-num-input-wrapper" %}

{# attributes #}
{% set numInputAttributes %}class="ue-range-num-input ue-input-min" type="number" min="{{minimumValue}}" max="{{maximumValue}}" step="{{step}}"{% endset %}

{# elements #}
{% set ueRangePrefixElem %}{% if showPrefix == "true" %}<span class="ue-range-prefix">{{prefixTextValue}}</span>{% endif %}{% endset %}
{% set ueRangeSufixElem %}{% if showSufix == "true" %}<span class="ue-range-suffix">{{sufixTextValue}}</span>{% endif %}{% endset %}
 
{% set ueNumPrefixElem %}{% if showPrefix == "true" %}<div class="ue-num-prefix">{{prefixTextValue}}</div>{% endif %}{% endset %}
{% set ueNumSufixElem %}{% if showSufix == "true" %}<div class="ue-num-suffix">{{sufixTextValue}}</div>{% endif %}{% endset %}

{% set labelElem %}{% if show_label == "true" %}<{{labelHtmlTag}} class="ue-range-label">{{label|raw}}</{{labelHtmlTag}}>{% endif %}{% endset %}
  
{% set ueRangeValuesElem %}
  <div class="ue-range-values">
    <div class="ue-range-min">{{ueRangePrefixElem}}<span class="ue-show-value-min">{{minimumValue}}</span>{{ueRangeSufixElem}}</div>
    <div class="ue-range-max">{{ueRangePrefixElem}}<span class="ue-show-value-max">{{maximumValue}}</span>{{ueRangeSufixElem}}</div>
  </div>
{% endset %}

{% set ueRangeValuesElemAbove %}{% if (showValuesBelowSlider == "true") and (rangeValuePosition == "above") %}{{ueRangeValuesElem}}{% endif %}{% endset %}
{% set ueRangeValuesElemBelow %}{% if (showValuesBelowSlider == "true") and (rangeValuePosition == "below") %}{{ueRangeValuesElem}}{% endif %}{% endset %}

{% set sliderElem %}<div id="{{uc_id}}_slider" class="ue-price-range-slider-element"></div>{% endset %}

{% set ueRangeNumInputWrapperElem %}
  {% if show_range_input == "true" %}
    <div class="ue-range-num-input-wrapper">
      <div class="{{ueNumInputWrapperClass}}">{{ueNumPrefixElem}}<input id="{{uc_id}}_num_input-min" class="ue-price-range-slider_num_input-min" value="{{minDefaultRangeValue}}" {{numInputAttributes}}>{{ueNumSufixElem}}</div>
      <div class="{{ueNumInputWrapperClass}}">{{ueNumPrefixElem}}<input id="{{uc_id}}_num_input-max" class="ue-price-range-slider_num_input-max" value="{{maxDefaultRangeValue}}" {{numInputAttributes}}>{{ueNumSufixElem}}</div>
    </div>
  {% endif %}
{% endset %}

{% set resetButtonElem %}{% if show_reset_button == "true" %}<div class="ue-price-range-slider-reset"><button class="ue-price-range-slider-reset-button">{{reset_button_text|raw}}</button></div>{% endif %}{% endset %}
{# end twig vars #}

{# widget html #}
<div id="{{uc_id}}" class="ue-price-range-slider {{filter_addclass}} uc-waitforload" {{filter_attributes|raw}} data-filtertype="general" data-generaltype="price" data-norefresh="true">
  
   {{labelElem}}
  
   <div class="ue-range-wrapper">  
     {{ueRangeValuesElemAbove}}  
     {{sliderElem}} 
     {{ueRangeValuesElemBelow}}
	 {{ueRangeNumInputWrapperElem}}  
     {{resetButtonElem}}
  </div>
  
</div>
{# end widget html #}