#{{uc_id}} .ue-mini-cart_container{
   display: flex;
   flex-direction: row;
   position: relative;
}
#{{uc_id}} .ue-mini-cart{
  display:flex;
  flex-direction:column;
  overflow:hidden;
  {% if show_toggle_button == "true" %}
   position:absolute;
   z-index:99999;
  {% endif %}
}
#{{uc_id}} .ue_mini_cart_toggle{
  transition: 200ms all;
}
#{{uc_id}} .ue-mini-cart-empty-message{
	display: none;
}

#{{uc_id}} .ue-mini-cart-item{
  transition: all .3s;
}

#{{uc_id}} .ue-mini-cart-item.ue-loading{
	opacity: .5;
}

{% if show_toggle_button == "true" %}
#{{uc_id}} .ue_mini_cart_toggle{
  display: inline-flex;
  gap: 6px;
  align-items: center;
  cursor:pointer;
}
{% endif %}

#{{uc_id}} .ue_cart_header{
  display:flex;
  justify-content: space-between;
  align-items: center;
}

{% if show_cart_close_button == "true" %}
#{{uc_id}} .ue_cart_close_button{
  display: flex;
  align-items: center;
  justify-content: center;
  cursor:pointer;
  overflow:hidden;
}
#{{uc_id}} .ue_cart_close_button svg{
  width:1em;
  height:1em;
}
{% endif %}

#{{uc_id}} .ue-mini-cart-items-holder{
  display: flex;
  flex-direction: column;
  overflow-y:scroll;
  transition: all .3s;
}

#{{uc_id}} .ue-mini-cart-item
{
  display:flex;
  align-items:center;
  transition: all .3s;
}

#{{uc_id}} .ue-mini-cart-item-content
{
  display:flex;
  flex-grow:1;
  align-self: stretch;
}

#{{uc_id}} .ue-mini-cart-content-wrapper
{
  display:block;
  flex-grow:1;
}

#{{uc_id}} .ue-mini-cart-item-title-text
{
  flex-grow:1;
}
#{{uc_id}} .ue_mini_price{
  display:inline-flex;
  align-items: center;
}

{% if show_remove_product_button == "true" %}
#{{uc_id}} .ue-mini-cart-item-delete
{
  display:flex;
  align-items:center;
  flex-grow:0;
  flex-shrink:0;
  cursor:pointer;
}
#{{uc_id}} .ue-mini-cart-item-delete svg{
  width:1em;
  height:1em;
}
#{{uc_id}} .ue-mini-cart-item-delete i{
  width:1em;
  height:1em;
  display:flex;
  align-content: center;
  justify-content: center;
}
.ue-mini-cart-item-delete {
  font-size:12px;
  line-height:1;
}

{% endif %}

#{{uc_id}} .ue-mini-cart-footer
{
  margin-top:auto;
}
{% if show_subtotal == "true" %}
#{{uc_id}} .ue-mini-cart-subtotal{
  display: flex;
  width: 100%;
  /* align-items: center; */
  align-items: baseline;
  position:relative;
}
  {% if fill_gap_with_dashes == "true" %}
  #{{uc_id}} .ue-total-gap-dots{
    border-bottom: 1px dashed {{subtotal_text_color}};
    flex-grow: 1;
  }
  {% endif %}
{% endif %}

#{{uc_id}} .ue_cart_btn_wrapper
{
  display: flex;
}

{% if show_product_quantity_input == "true" %}
#{{uc_id}} .ue_mini_quantity_input{
  display:inline-flex;
  background: #fff;
  border-radius: 4px;
  border: 1px solid #ddd;
}
#{{uc_id}} .ue_mini_minus,
#{{uc_id}} .ue_mini_plus {
  display:inline-flex;
  justify-content: center;
  align-items: center;
  text-align: center;
  cursor: pointer;
  user-select: none;
  -moz-user-select: none;
  -webkit-user-select: none;
  -ms-user-select: none;
}
#{{uc_id}} .ue_mini_input {
  background: #fff;
  text-align: center;
  font-size: 12px;
  vertical-align: middle;
  padding:0;
  border:none;
  border-radius:0;
}
#{{uc_id}} .ue_mini_input::-webkit-outer-spin-button,
#{{uc_id}} .ue_mini_input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}

#{{uc_id}} .ue_mini_input[type=number] {
  -moz-appearance: textfield;
}

{% endif %}


#{{uc_id}} .ue-mini-cart-items-holder::-webkit-scrollbar {
  -webkit-appearance: none;
  width: 4px;
}
#{{uc_id}} .ue-mini-cart-items-holder::-webkit-scrollbar-track {
  background-color: transparent;
}
#{{uc_id}} .ue-mini-cart-items-holder::-webkit-scrollbar-thumb {
  background-color: #79797945;
  border-radius:5px;
}
.ue-product-count{
  line-height: 1;
}


{% if show_product_image != "true" %}
#{{uc_id}} .ue-mini-cart-item-image{
  display:none!important;
}
{% endif %}

{% if show_remove_product_button != "true" %}
#{{uc_id}} .ue-mini-cart-item-delete{
  display:none!important;
}
{% endif %}

{% if show_product_quantity_input != "true" %}
#{{uc_id}} .ue_mini_quantity_input{
  display:none!important;
}
{% endif %}

{% if show_product_quantity != "true" %}
#{{uc_id}} .ue_mini_qty{
  display:none!important;
}
{% endif %}