#{{uc_id}} *
{
  box-sizing: border-box;
}
#{{uc_id}}
{
  position:relative;
}

#{{uc_id}} .ue-whatsapp-chat-button-container
{
  display:inline-block;
  position:relative;
}

#{{uc_id}} .ue-whatsapp-chat-button
{
  display:flex;
  align-items:center;
  justify-content:center;
  position:relative;
  cursor:pointer;
  line-height:1em;
  transition:0.5s;
}

#{{uc_id}} .ue-whatsapp-chat-button-icon
{
  flex-grow:0;
  flex-shrink:0;
  display:flex;
  align-items:center;
  justify-content:center;
}

#{{uc_id}} .ue-whatsapp-chat-button-label-spacing
{
  flex-grow:0;
  flex-shrink:0;
}


#{{uc_id}} .ue-whatsapp-chat-button svg
{
  height:1em;
  width:1em;
}

#{{uc_id}} .ue-whatsapp-chat-popup
{
  --yPosition: -50px;
  position:absolute;
  background:#eee;
  overflow:hidden;
  visibility: hidden;
  opacity: 0;
  transition: transform 500ms cubic-bezier(.215,.61,.355,1), opacity 200ms cubic-bezier(.215,.61,.355,1), visibility 200ms cubic-bezier(.215,.61,.355,1);
  /* 
  ** Old placement start
  */
  /*
  {% if placement == "bottom-left" %}left:0px;bottom:calc(10px + {{button_size}});transform: translateY(50px) scale(.9);{% endif %}
  {% if placement == "bottom-right" %}right:0px;bottom:calc(10px + {{button_size}});transform: translateY(50px) scale(.9);{% endif %}
  {% if placement == "top-right" %}right:0px;top:calc(10px + {{button_size}});transform: translateY(-50px) scale(.9);{% endif %}
  {% if placement == "top-left" %}left:0px;top:calc(10px + {{button_size}});transform: translateY(-50px) scale(.9);{% endif %}
  */
   /* 
  ** Old placement end
  */
  {% if placement == "bottom-left" %}right:0;top:calc(10px + {{button_size}});transform: translateY(var(--yPosition)) scale(.9);{% endif %}
  {% if placement == "bottom-right" %}left:0;top:calc(10px + {{button_size}});transform: translateY(var(--yPosition)) scale(.9);{% endif %}
  {% if placement == "top-right" %}--yPosition: 50px; left:0;bottom:calc(10px + {{button_size}});transform: translateY(var(--yPosition)) scale(.9);{% endif %}
  {% if placement == "top-left" %}--yPosition: 50px; right:0;bottom:calc(10px + {{button_size}});transform: translateY(var(--yPosition)) scale(.9);{% endif %}
}

#{{uc_id}} .ue-whatsapp-chat-popup.uc-show
{
  opacity: 1;
  visibility: visible;
  transform: translateY(0) scale(1);
}

#{{uc_id}} .ue-whatsapp-chat-popup-title
{
  display:flex;
  line-height:1em;
}

#{{uc_id}} .ue-whatsapp-chat-popup-title-text
{
  flex-grow:1;
  text-align: left;
}

#{{uc_id}} .ue-whatsapp-chat-popup-title-icon
{
  flex-grow:0;
  flex-shrink:0;
}

#{{uc_id}} .ue-whatsapp-chat-popup-title-close
{
  flex-grow:0;
  flex-shrink:0;
  cursor:pointer;
}

#{{uc_id}} .ue-whatsapp-chat-popup-title-icon-spacing
{
  flex-grow:0;
  flex-shrink:0;
  width:10px;
}
#{{uc_id}} .ue-whatsapp-chat-popup-message-send
{
  display:flex;
}

#{{uc_id}} .ue-whatsapp-chat-popup-message-text
{
  text-align: left;
}

#{{uc_id}} .ue-whatsapp-chat-popup-message-send-link
{
  display:inline-flex;
  text-decoration:none;
  transition:0.5s;
}
#{{uc_id}} .ue-whatsapp-chat-popup-message-send-link-icon-spacing
{
  width:10px;
}

#{{uc_id}} .ue-whatsapp-chat-agent
{
  display:flex;
  width:100%;
  align-items:center;
  position: relative;
}

#{{uc_id}} .ue-whatsapp-chat-agent:last-child
{
  margin-bottom:0;
}

#{{uc_id}} .ue-whatsapp-chat-agent-image-spacing
{
  flex-grow:0;
  flex-shrink:0;
  width:15px;
}

#{{uc_id}} .ue-whatsapp-chat-agent-image
{
  flex-grow:0;
  flex-shrink:0;
}

#{{uc_id}} .ue-whatsapp-chat-agent-image img
{
  object-fit: cover;
  display:block;
}

.ue-whatsapp-chat-agent-details-title, .ue-whatsapp-chat-agent-details-message, .ue-whatsapp-chat-agent-details-message-text
{
  line-height:1em;
  margin-top:3px;
}

.ue-whatsapp-chat-agent-details-message, .ue-whatsapp-chat-popup-agents-message-text
{
  display: none;
}

.ue-whatsapp-chat-agent-details-subtitle
{
  font-size:10px;
  line-height:1em;
}

.ue-whatsapp-chat-agent-details-hours
{
  font-size:10px;
  margin-top:3px;
  line-height:1em;
}

#{{uc_id}}  .ue-whatsapp-chat-popup-message-input textarea
{
  width:100%;
  box-sizing:border-box;
}

{% if show_animation == "true" %} 
  
 #{{uc_id}} .ue-whatsapp-chat-button::before
 {
   position: absolute;
   content: "";
   width: 100%;
   height: 100%;
   display: flex;
   align-items: center;
   justify-content: center;
   animation: whatsapp-pulse 2s infinite;
   z-index: -1;
   opacity: 0;
 }

 @keyframes whatsapp-pulse {
    0% {
        transform: scale(0.5);
        opacity: 1;
    }
    80% {
         transform: scale(1.4);
         opacity: 0;
    }
    100% {
          transform: scale(2);
          opacity: 0;
    }
  }
{% endif %}

#{{uc_id}} .ue-whatsapp-chat-popup-agents-message-container 
{
  position: relative;
  display: none;
  transition: all 0.8s ease-in-out;
}

#{{uc_id}} .ue-whatsapp-chat-popup-agents-message-container.uc_show 
{
  display:block;
}

#{{uc_id}} .ue-whatsapp-chat-popup-agents-message-container-text 
{
}

#{{uc_id}} .ue-whatsapp-chat-popup-agents-message-container-backBtn
{
  position: absolute;
  top: 0px;
  right: 0px;
  padding:10px;
  font-size:10px;
  background-color:gray;
  color:white;
  border-radius:50%;
  opacity: 0;
  transition:0.2s;
  line-height:1em;
  width:20px;
  height:20px;
  display:flex;
  align-items:center;
  justify-content:center;
}

#{{uc_id}} .ue-whatsapp-chat-agent.uc_active .ue-whatsapp-chat-popup-agents-message-container-backBtn
{
  opacity: 1
}

#{{uc_id}} .ue-whatsapp-chat-popup-message-text.uc_hide 
{ 
	display: none;
}

#{{uc_id}} .ue-whatsapp-chat-agent:last-child.uc_active
{
  margin-bottom: 10px;
}