{% if apply_pattern == 'true' %}

{% set pattern_height_arg = "100%"%}

	#{{uc_id}} .ue_background_pattern {
      {% if pattern_type == 'pattern_1' %} 
          --pattern: url("data:image/svg+xml,%3Csvg width='{{pattern_width_nounit}}' height='{{pattern_height_arg}}' viewBox='0 0 32 64' fill='%23{{pattern_color|replace({'\#': ''})}}' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M0 28h20V16h-4v8H4V4h28v28h-4V8H8v12h4v-8h12v20H0v-4zm12 8h20v4H16v24H0v-4h12V36zm16 12h-4v12h8v4H20V44h12v12h-4v-8zM0 36h8v20H0v-4h4V40H0v-4z' /%3E%3C/svg%3E");
      {% elseif pattern_type == 'pattern_2' %}
          --pattern: url("data:image/svg+xml,%3Csvg width='{{pattern_width_nounit}}' height='{{pattern_height_arg}}' viewBox='0 0 64 60' fill='%23{{pattern_color|replace({'\#': ''})}}' xmlns='http://www.w3.org/2000/svg'%3E%3cpath d='M64 30.2c-2 4.2-4.3 8-6.4 12l-5 9.8-.6 1-12-21.8c-.3-.6-.4-1.2 0-1.8L51.8 7.8l.2-.2 5 9.2L63.6 29c.2.3.3.7.5 1.2 0-.1 0 0 0 0zm-64 7.4c2.4-.2 4.8 0 7 .1l15 .3c2.6 0 4.2.7 5.5 3 3.6 6.4 7.6 12.6 11.4 18.8 0 .1.1.2 0 0L28 60c-3.8-.1-7.4 0-11.4 0-2.6 0-3.7-1-4.8-3L.1 38v-.3zm.2-15.3l9-14.7 3.7-6C13.8.2 15.2.2 16.4.1L39 0h.4L36 5.5l-9.3 15.3c-1 1.5-2.2 1.4-3.5 1.4l-17.8.4-5.2.1v-.4zm2-.7h1.2-1.2z'/%3e%3cpath d='M2 21.8h1.2H2z'/%3e%3c/svg%3e");
      {% elseif pattern_type == 'pattern_3' %}
          --pattern: url("data:image/svg+xml,%3Csvg width='{{pattern_width_nounit}}' height='{{pattern_height_arg}}' viewBox='0 0 64 56' fill='%23{{pattern_color|replace({'\#': ''})}}' xmlns='http://www.w3.org/2000/svg'%3E%3cpath d='M48 .3H16L0 28l16 27.7h32L64 28 48 .3zm-4.3 48H20.3L8.6 28 20.3 7.7h23.4L55.4 28 43.7 48.3z'/%3e%3c/svg%3e");
      {% elseif pattern_type == 'pattern_4' %}
          --pattern: url("data:image/svg+xml,%3Csvg width='{{pattern_width_nounit}}' height='{{pattern_height_arg}}' viewBox='0 0 64 64' fill='%23{{pattern_color|replace({'\#': ''})}}' xmlns='http://www.w3.org/2000/svg'%3E%3cpath d='M57.2 29c-4.3-2-9-2-13.3 0l-6.5 2.8-5.3-5.2 3-6.6c2-4.2 2-9 0-13.3L32 0l-3 6.8c-2 4.2-2 9 0 13.3l3 6.5-5.3 5.3-6.4-3C16 27 11 27 7 29l-7 3 6.8 3c4.3 2 9 2 13.3 0l6.4-2.8 5.2 5.2-3 6.5c-2 4.2-2 9 0 13.3l3 6.8 3-6.8c2-4.2 2-9 0-13.3l-3-6.5 5.3-5.3 6.5 2.8c4.3 2 9 2 13.3 0l6.8-3-6.6-3z'/%3e%3c/svg%3e");
      {% elseif pattern_type == 'pattern_5' %}
          --pattern: url("data:image/svg+xml,%3Csvg width='{{pattern_width_nounit}}' height='{{pattern_height_arg}}' viewBox='0 0 64 64' fill='%23{{pattern_color|replace({'\#': ''})}}' xmlns='http://www.w3.org/2000/svg'%3E%3cpath d='M0 0h32v32H0z'/%3e%3cpath d='M32 32h32v32H32z'/%3e%3c/svg%3e");
      {% elseif pattern_type == 'pattern_6' %}
          --pattern: url("data:image/svg+xml,%3Csvg width='{{pattern_width_nounit}}' height='{{pattern_height_arg}}' viewBox='0 0 64 64' fill='%23{{pattern_color|replace({'\#': ''})}}' xmlns='http://www.w3.org/2000/svg'%3E%3ccircle cx='32' cy='32' r='32'/%3e%3c/svg%3e");
      {% elseif pattern_type == 'pattern_7' %}
          --pattern: url("data:image/svg+xml,%3Csvg width='{{pattern_width_nounit}}' height='{{pattern_height_arg}}' viewBox='0 0 64 64' fill='%23{{pattern_color|replace({'\#': ''})}}' xmlns='http://www.w3.org/2000/svg'%3E%3cpath d='M32 64c-1-1-2-2.3-3.2-3.4L16.6 48l-11-11C4 35 2 33.4.2 31.6L32.4.1l3.4 3.6 11.6 12 10 10.2 6.6 6.8v.2l-6 5.6c-2 2-3.7 3.8-5.6 5.6l-5 5c-3 3-5.8 6-8.8 9l-6.3 6H32zm27.5-31.4l-27.2-28-27.6 27 27.5 28 27.3-27zM0 19l4.4-4.3 10.2-10L19 .5c.1-.1.2-.3.4-.5H24c-2 2-3.7 3.8-5.6 5.6L6 18l-6 5.5L0 19zm19.8 45l-4-4c-1.5-1.5-3-3-4.4-4.5l-5.8-6-5-5C.5 44.3.2 44 0 44v-4.5L3.4 43l9.2 9.2 2.2 2.4L24 64h-4.3zm20.8 0l3.4-3.6 14.3-14.2 5-5c.2-.2.4-.3.6-.4v4.5l-6.4 6.2-8 8.2-4.3 4.3h-4.6z'/%3e%3cpath d='M44.4 0l4.3 4.4 9.6 10 4.4 4.5 1.3 1v4.4c-2-1.8-3.6-3.6-5.4-5.7a9 9 0 0 1-1.2-1c-2-2-3.7-3.8-5.5-5.7-2.2-2.3-4.5-4.5-6.7-6.8-1.7-1.7-3.3-3.5-5-5.3h4.2zM13 0L8 5.2l-8 7.4L0 8c.2-.1.4-.3.5-.4l5.2-5L8.2 0h5zM0 50.6c.4.4 1 .8 1.3 1.2l11.5 11.6c.2.2.3.4.5.6H9c-.1-.2-.2-.4-.4-.5C5.8 60.5 3 57.8.1 55v-4.3zM51.5 64l3-3.2 9.5-9.3v5l-3.3 3.2-4.5 4.4h-4.7zM64 13.6l-4.6-4.8c-2-2-4-4-5.8-6-1-1-2-2-2.8-3h4.4c.1.2.3.4.4.6L60 5l4 4.3v4.3zm0-11L61.5 0H64v2.7zm-64 59L2.4 64H0v-2.4zM1.6 0L0 1.6V0h1.6zm60.8 64l1.6-1.6V64h-1.6zm-30-10.8l-21-21.5 21-20.6 21 21.5-21 20.6zm0-37.5l-16.5 16 16.4 16.7 16.4-16-16.3-16.7zM22 32.2l10-9.8c3.5 3.3 7 6.5 10.6 10l-10 9.7-10.6-10zm10.4 5.6l5-5.8-5-5-5.3 5.2 5.3 5.5z'/%3e%3c/svg%3e");
      {% elseif pattern_type == 'pattern_8' %}
          --pattern: url("data:image/svg+xml,%3Csvg width='{{pattern_width_nounit}}' height='{{pattern_height_arg}}' viewBox='0 0 64 64' fill='%23{{pattern_color|replace({'\#': ''})}}' xmlns='http://www.w3.org/2000/svg'%3E%3cpath d='M32 0a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0 56.3c-13.4 0-24.3-11-24.3-24.3S18.6 7.7 32 7.7s24.3 11 24.3 24.3-11 24.3-24.3 24.3z'/%3e%3c/svg%3e");
      {% elseif pattern_type == 'pattern_9' %}
          --pattern: url("data:image/svg+xml,%3Csvg width='{{pattern_width_nounit}}' height='{{pattern_height_arg}}' viewBox='0 0 64 64' fill='%23{{pattern_color|replace({'\#': ''})}}' xmlns='http://www.w3.org/2000/svg'%3E%3cpath d='M34.5 64h-5.3c0-13.7-12.6-26-29.3-27.5V20.8c3-6.7 7.5-12.4 13.8-16A39 39 0 0 1 33.4 0C47 .1 58.6 9.3 64 21.3v15.2C47 37.7 34.2 51 34.5 64zM2.3 31.7c14 1.7 23.7 8.2 29.5 21 6-12.7 15.7-19.2 29.6-21-1.7-15-14-27-29.5-27.2-15.5 0-28 12.2-29.6 27.2z'/%3e%3c/svg%3e");
      {% elseif pattern_type == 'pattern_10' %}
          --pattern: url("data:image/svg+xml,%3Csvg width='{{pattern_width_nounit}}' height='{{pattern_height_arg}}' viewBox='0 0 64 64' fill='%23{{pattern_color|replace({'\#': ''})}}' xmlns='http://www.w3.org/2000/svg'%3E%3cpath d='M64 0h0-3L47.3 13.7l-5.5-5.5H22l-5.5 5.5L3 0H0h0v3l13.7 13.7-5.5 5.5V42l5.5 5.5L0 61v3h3l13.7-13.7 5.5 5.5H42l5.5-5.5L61 64h3 0v-3L50.3 47.3l5.5-5.5V22l-5.5-5.5L64 3V0zM52 23.7v16.5L40.3 52H23.7L12 40.3V23.7L23.8 12h16.5L52 23.7zm-23.7-.5l-5 5v7.4l5 5h7.4l5-5v-7.4l-5-5z'/%3e%3c/svg%3e");
      {% elseif pattern_type == 'pattern_11' %}
          --pattern: url("data:image/svg+xml,%3Csvg width='{{pattern_width_nounit}}' height='{{pattern_height_arg}}' viewBox='0 0 64 64' fill='%23{{pattern_color|replace({'\#': ''})}}' xmlns='http://www.w3.org/2000/svg'%3E%3cpath d='M64 24V9c-5 0-9-4-9-9H40c0 6 2 11.3 5.7 15.5l-9 9c-1.4-1-3-1.4-4.7-1.4s-3.3.5-4.6 1.3l-9-9A24 24 0 0 0 24 0H9a9 9 0 0 1-9 9v15c6 0 11.4-2.2 15.6-5.8l9 9c-1 1.4-1.5 3-1.5 5 0 1.7.5 3.4 1.4 4.7l-9 9C11.3 42.2 6 40 0 40v15c1.7 0 3.4.5 4.7 1.4 1.2.7 2 1.7 2.8 2.8 1 1.4 1.5 3 1.5 4.8h15c0-6-2-11.3-5.7-15.5l9-9c1.4 1 3 1.4 4.7 1.4 1.8 0 3.5-.5 5-1.4l9 9C42.2 52.6 40 58 40 64h15a9 9 0 0 1 9-9V40a24 24 0 0 0-15.4 5.6l-9-9c.8-1.3 1.3-3 1.3-4.6s-.5-3.4-1.4-4.7l9-9C52.7 21.8 58 24 64 24z'/%3e%3c/svg%3e");
      {% elseif pattern_type == 'pattern_12' %}
          --pattern: url("data:image/svg+xml,%3Csvg width='{{pattern_width_nounit}}' height='{{pattern_height_arg}}' viewBox='0 0 64 64' fill='%23{{pattern_color|replace({'\#': ''})}}' xmlns='http://www.w3.org/2000/svg'%3E%3cpath d='M22 0v6.7c-1.6.4-2.8 2-2.8 3.6 0 .7.2 1.3.5 2l-8 8c-.4-.2-1-.3-1.4-.3-1.5 0-2.8 1-3.4 2.2H0v2h6.6c.2 1.6 1.3 2.8 2.7 3.2v10C8 37.8 7 38.7 6.7 40H0v2h6.7c.4 1.6 2 2.8 3.6 2.8.6 0 1.2-.2 1.7-.4l7.6 7.6c-.4.6-.6 1.3-.6 2 0 1.8 1.3 3.3 3 3.7V64h2v-6.8c1.2-.4 2-1.4 2.4-2.6h10.4c.4 1.3 1.3 2.3 2.6 2.6V64h2v-6.7c1.6-.4 2.8-2 2.8-3.6 0-.6-.1-1-.3-1.5l8-8c.5.3 1 .4 1.7.4 1.7 0 3.2-1.2 3.6-2.8H64v-2h-6.7c-.4-1.3-1.3-2.3-2.6-2.6v-10c1.5-.4 2.6-1.7 2.7-3.2H64v-2h-7c-.6-1.3-2-2.2-3.4-2.2-.5 0-1 .1-1.4.3l-8-8c.3-.6.6-1.2.6-2 0-2-1.5-3.5-3.4-3.7V0h-2v7c-1 .5-1.7 1.3-2 2.4h-11C26.2 8 25.3 7 24 6.8V0h-2zm4.6 11.3h10.8c.4 1.6 2 2.8 3.6 2.8.5 0 1-.1 1.4-.3l8 8c-.3.6-.5 1.2-.5 2 0 1.7 1.2 3.2 2.8 3.6v10c-1.6.4-2.8 2-2.8 3.6 0 .6.1 1 .3 1.5l-8 8c-.5-.3-1-.4-1.7-.4-1.7 0-3.2 1.2-3.6 2.8H26.4c-.4-1.6-2-2.8-3.6-2.8-.6 0-1 .1-1.6.4L13.6 43c.3-.5.5-1.2.5-2 0-1.7-1.2-3.2-2.8-3.6v-10c1.6-.4 2.8-2 2.8-3.6 0-.8-.3-1.6-.7-2.2l7.8-7.8c.5.3 1.2.5 1.8.5 1.8 0 3.2-1.2 3.6-2.8zm5.4 17c-2 0-3.8 1.7-3.8 3.8s1.7 3.8 3.8 3.8 3.8-1.7 3.8-3.8-1.7-3.8-3.8-3.8z'/%3e%3c/svg%3e");
      {% elseif pattern_type == 'pattern_13' %}
          --pattern: url("data:image/svg+xml,%3Csvg width='{{pattern_width_nounit}}' height='{{pattern_height_arg}}' viewBox='0 0 64 64' fill='%23{{pattern_color|replace({'\#': ''})}}' xmlns='http://www.w3.org/2000/svg'%3E%3cpath d='M32 25.7l32 31.8v-8L32 17.7l-32 32v8zm0-16l32 31.8v-8L32 1.7l-32 32v8zM25.7 0h-8L0 17.5v8zM64 25.5v-8L46.4 0h-8zM9.5 0h-8L0 1.5v8zM64 9.5v-8L62.5 0h-8zM9.7 64L32 41.7 54.4 64h0 8 0L32 33.7 1.6 64h0zM32 57.8l6.3 6.2h8L32 49.8 17.7 64h8z'/%3e%3c/svg%3e");
      {% elseif pattern_type == 'pattern_14' %}
          --pattern: url("data:image/svg+xml,%3Csvg width='{{pattern_width_nounit}}' height='{{pattern_height_arg}}' viewBox='0 0 64 67' fill='%23{{pattern_color|replace({'\#': ''})}}' xmlns='http://www.w3.org/2000/svg'%3E%3cpath d='M64 44.6l-1.2-2.2-3.8-7c-.2-.4-.5-1-.7-1.3s-.2-.7 0-1l3.2-6 2.3-4.2c0-.1.1-.2.2-.3v22zm0-37L62.5 5 60 .5c0-.2-.1-.3-.2-.5H64v7.5zM0 67v-7.6c.3.5.5 1 .8 1.5l3 5.7c.1.2.2.3.3.5H0zm60 0l1-2 3-5.3s0-.1.1-.1V67h-4zm-2.2-48l-1.2 2-4.4 7c-.3.5-.6 1-1 1.5-.1.2-.4.3-.6.3h-2.8l-3.6.1H41h-2-.7c.2-.4.4-.7.6-1l4.7-7.7c.3-.6.7-1 1-1.7.2-.3.5-.5 1-.5h.2 3 3.7 1.8 3c.4-.2.5-.2.6-.1 0-.1 0-.1 0 0zM38.4.3h.6l3.3.1 3.6.1h1.7l3 .1c.3 0 .6.2.8.5l2 3.3 3 4.6 1.4 2.3c.1.1.1.2.2.4h-1.4-1.8c-1 0-2.3-.1-3.4-.1h-1.6c-1.2 0-2.4-.1-3.7-.1h-.6c-.3 0-.5-.2-.6-.4l-4.3-7-1.8-3c-.2-.4-.2-.6-.3-.8zM38.3 67c.2-.4.4-.7.6-1l4.5-7.3c.4-.7 1-1.5 1.3-2.2.2-.3.4-.4.8-.4H48h2.7 3.5 3.5.2l-.3.7-4.8 7.8-1.2 2c-.2.3-.5.4-.8.5h-3H44h-3.4-2c-.1-.1-.2-.1-.4-.1zm19.5-18.5c-1 0-2-.1-3-.1h-1.4c-1.2 0-2.5-.1-3.7-.1s-2.4-.1-3.6-.1h-.6c-.2 0-.5-.1-.6-.3l-2.2-3.5-3.6-5.8c-.2-.4-.5-.8-.7-1.2h1H41l3.5.1 3.4.1h2 1c.3 0 .5.2.7.4l2.8 4.6 3.4 5.6s0 .1.1.3zM32 4l.7 1.2 3 5.6 2 4c.2.3.2.6 0 1l-3.8 7c-.6 1.2-1.3 2.3-2 3.5-.1.1-.1.2-.3.4l-1-1.5-3.7-6.8c-.4-.8-.8-1.5-1.3-2.3-.2-.4-.2-.7 0-1 1-1.7 2-3.5 3-5.2l2.7-5c.3-.3.5-.6.7-1zM6.3 11.5l1-1.6C8 8.5 9 7.2 9.8 5.8l3-4.8c.2-.3.4-.4.7-.4L16 .5l3.7-.1L23 .3c.7 0 1.4-.1 2-.1.1 0 .2 0 .4.1-.2.4-.4.8-.6 1l-3 5.3-2.5 4c-.3.5-.7.5-1.2.5l-3.4.1-3.4.1-3.3.1H6.6c-.1.1-.2 0-.3 0zM32 63.3c-.3-.6-.7-1.2-1-1.8l-3.4-6.3-1.4-2.6c-.2-.4-.2-.7 0-1l2.5-4.7 2.4-4.5c.3-.5.5-1 1-1.6.2.4.5.8.7 1.2l4 7.4 1.2 2.2c.2.3.2.6 0 1l-2 3-2 3.6c-.6 1.2-1.3 2.4-2 3.5 0 .3-.1.4-.2.5zM25.7 30c-.2 0-.4.1-.6.1-1 0-2 0-2.8-.1l-6-.2h-2.6c-.5 0-1-.2-1-.6l-3.4-5.5-2.6-4.3c-.1-.1-.1-.3-.2-.5h.3 3 5 4c.5 0 1 .2 1 .7l6 9.7c-.1.1 0 .3.1.5z'/%3e%3cpath d='M25.8 37.2c-.2.4-.4.7-.6 1l-5.7 9.2c-.3.5-.6.6-1.2.6h-4-3.6l-3.6.1H6c.3-.6.7-1 1-1.7l5-8 .6-1c.2-.3.5-.4.8-.4H18h3.4l3.4-.1c.3.1.7.1 1 .1zM6.3 55.8h.4l4.4.1h3.4 3.7.6c.3 0 .5.2.6.4A24 24 0 0 0 21 59l3.6 6 1 1.8s0 .1.1.1h-2c-1 0-2 0-3-.1-1.2 0-2.5-.1-3.7-.1h-1.4c-.7 0-1.4 0-2-.1-.4 0-.7-.2-1-.6l-5-8c-.4-.6-.8-1.3-1.2-2-.1-.2-.2-.4-.3-.5zM0 44.7v-22c.3.4.5 1 .8 1.3l4 7.4 1 1.7c.2.4.2.8 0 1.2l-3.4 6.3-2 3.7c-.1.2-.2.4-.3.5zM0 0h4.3L.1 7.8 0 0z'/%3e%3c/svg%3e");
      {% elseif pattern_type == 'pattern_15' %}
          --pattern: url("data:image/svg+xml,%3Csvg width='{{pattern_width_nounit}}' height='{{pattern_height_arg}}' viewBox='0 0 84 84' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23{{pattern_color|replace({'\#': ''})}}'%3E%3Cpath d='M84 23c-4.417 0-8-3.584-8-7.998V8h-7.002C64.58 8 61 4.42 61 0H23c0 4.417-3.584 8-7.998 8H8v7.002C8 19.42 4.42 23 0 23v38c4.417 0 8 3.584 8 7.998V76h7.002C19.42 76 23 79.58 23 84h38c0-4.417 3.584-8 7.998-8H76v-7.002C76 64.58 79.58 61 84 61V23zM59.05 83H43V66.95c5.054-.5 9-4.764 9-9.948V52h5.002c5.18 0 9.446-3.947 9.95-9H83v16.05c-5.054.5-9 4.764-9 9.948V74h-5.002c-5.18 0-9.446 3.947-9.95 9zm-34.1 0H41V66.95c-5.053-.502-9-4.768-9-9.948V52h-5.002c-5.184 0-9.447-3.946-9.95-9H1v16.05c5.053.502 9 4.768 9 9.948V74h5.002c5.184 0 9.447 3.946 9.95 9zm0-82H41v16.05c-5.054.5-9 4.764-9 9.948V32h-5.002c-5.18 0-9.446 3.947-9.95 9H1V24.95c5.054-.5 9-4.764 9-9.948V10h5.002c5.18 0 9.446-3.947 9.95-9zm34.1 0H43v16.05c5.053.502 9 4.768 9 9.948V32h5.002c5.184 0 9.447 3.946 9.95 9H83V24.95c-5.053-.502-9-4.768-9-9.948V10h-5.002c-5.184 0-9.447-3.946-9.95-9zM50 50v7.002C50 61.42 46.42 65 42 65c-4.417 0-8-3.584-8-7.998V50h-7.002C22.58 50 19 46.42 19 42c0-4.417 3.584-8 7.998-8H34v-7.002C34 22.58 37.58 19 42 19c4.417 0 8 3.584 8 7.998V34h7.002C61.42 34 65 37.58 65 42c0 4.417-3.584 8-7.998 8H50z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E");
      {% endif %}
    }

	#{{uc_id}} .ue_background_pattern {
      position: absolute;
      top: 0px;
      left: 0px;
      width: 100%;
      height: 100%;
      background-repeat:repeat;
      background-image: var(--pattern);
      {% if pattern_flip_horizontally == 'true' or pattern_flip_vertically == 'true' %}
        transform: {% if pattern_flip_vertically == 'true' %} rotateX(180deg) {% endif %} {% if pattern_flip_horizontally == 'true' %} rotateY(180deg) {% endif %};
      {% endif %}
    }

{% endif %}



{% if apply_mask == 'true' %}

  #{{uc_id}} .ue_background_mask {
    {% if mask_type == 'abstract_polygon' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cpolygon points='0%2c587.1 132.9%2c720 0%2c852.9 0%2c1079.9 359.9%2c720 0%2c360.1 '/%3e%3cpolygon points='0%2c0 0%2c133.2 586.8%2c720 0%2c1306.8 0%2c1440 93.8%2c1440 813.8%2c720 93.8%2c0 '/%3e%3cpolygon points='389.9%2c1440 616.9%2c1440 960%2c1096.9 1303.1%2c1440 1530.1%2c1440 960%2c869.9 '/%3e%3cpolygon points='843.8%2c1440 1076.2%2c1440 960%2c1323.8 '/%3e%3cpolygon points='1303.1%2c0 960%2c343.1 616.9%2c0 389.9%2c0 960%2c570.1 1530.1%2c0 '/%3e%3cpolygon points='843.8%2c0 960%2c116.2 1076.2%2c0 '/%3e%3cpolygon points='1560.1%2c720 1920%2c1079.9 1920%2c852.9 1787.1%2c720 1920%2c587.1 1920%2c360.1 '/%3e%3cpolygon points='1826.2%2c0 1106.2%2c720 1826.2%2c1440 1920%2c1440 1920%2c1306.8 1333.2%2c720 1920%2c133.2 1920%2c0 '/%3e%3c/svg%3e");
    {% elseif mask_type == 'hexagon' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cpath d='M1894.4%2c1156.7l-91.5-52.8c-11-6.4-17.8-18.1-17.8-30.8V967.5c0-12.7%2c6.8-24.4%2c17.8-30.8l91.5-52.8 c7.9-4.5%2c17-5.8%2c25.6-3.9V611.4c-5.9-0.1-11.8-1.7-17.1-4.7l-90.8-57.1c-11-6.4-17.8-18.1-17.8-30.8V404.7 c0-12.7%2c6.8-24.4%2c17.8-30.8l90.8-57.1c5.3-3.1%2c11.2-4.6%2c17.1-4.7V0H0v1440h1920v-279.5C1911.4%2c1162.5%2c1902.2%2c1161.2%2c1894.4%2c1156.7z M1672.9%2c191.2c0-9.6%2c5.1-18.5%2c13.5-23.3l69.1-39.9c8.3-4.8%2c18.6-4.8%2c26.9%2c0l69.1%2c39.9c8.3%2c4.8%2c13.5%2c13.7%2c13.5%2c23.3v79.7 c0%2c9.6-5.1%2c18.5-13.5%2c23.3l-69.1%2c39.9c-8.3%2c4.8-18.6%2c4.8-26.9%2c0l-69.1-39.9c-8.3-4.8-13.5-13.7-13.5-23.3V191.2z M1636.5%2c326.9 l98.8%2c57.1c11%2c6.4%2c17.8%2c18.1%2c17.8%2c30.8v114.1c0%2c12.7-6.8%2c24.4-17.8%2c30.8l-98.8%2c57.1c-11%2c6.3-24.5%2c6.3-35.5%2c0l-98.8-57.1 c-11-6.4-17.8-18.1-17.8-30.8V414.8c0-12.7%2c6.8-24.4%2c17.8-30.8l98.8-57.1C1611.9%2c320.6%2c1625.5%2c320.6%2c1636.5%2c326.9z M1601.1%2c689.5 v125c0%2c12.7-6.8%2c24.4-17.8%2c30.8l-108.2%2c62.5c-11%2c6.4-24.5%2c6.4-35.5%2c0l-108.2-62.5c-11-6.4-17.8-18.1-17.8-30.8v-125 c0-12.7%2c6.8-24.4%2c17.8-30.8l108.2-62.5c11-6.4%2c24.5-6.4%2c35.5%2c0l108.2%2c62.5C1594.3%2c665.1%2c1601.1%2c676.8%2c1601.1%2c689.5z M1345.2%2c180.6 c0-11.2%2c6-21.5%2c15.6-27.1l82.2-47.4c9.7-5.6%2c21.6-5.6%2c31.3%2c0l82.2%2c47.4c9.7%2c5.6%2c15.6%2c15.9%2c15.6%2c27.1v94.9c0%2c11.2-6%2c21.5-15.6%2c27.1 l-82.2%2c47.4c-9.7%2c5.6-21.6%2c5.6-31.3%2c0l-82.2-47.4c-9.7-5.6-15.6-15.9-15.6-27.1V180.6z M1322.5%2c331.9l97.1%2c56.1 c11%2c6.4%2c17.8%2c18.1%2c17.8%2c30.8v112.1c0%2c12.7-6.8%2c24.4-17.8%2c30.8l-97.1%2c56.1c-11%2c6.3-24.5%2c6.3-35.5%2c0l-97.1-56.1 c-11-6.4-17.8-18.1-17.8-30.8V418.8c0-12.7%2c6.8-24.4%2c17.8-30.8l97.1-56.1C1297.9%2c325.6%2c1311.5%2c325.6%2c1322.5%2c331.9z M1043.1%2c188.5 c0-12.7%2c6.8-24.4%2c17.8-30.8l75.3-43.5c11-6.4%2c24.5-6.4%2c35.5%2c0l75.3%2c43.5c11%2c6.4%2c17.8%2c18.1%2c17.8%2c30.8v87c0%2c12.7-6.8%2c24.4-17.8%2c30.8 l-75.3%2c43.5c-11%2c6.4-24.5%2c6.4-35.5%2c0l-75.3-43.5c-11-6.4-17.8-18.1-17.8-30.8V188.5z M1117.4%2c904.4l-98.8-57.1 c-11-6.4-17.8-18.1-17.8-30.8V702.5c0-12.7%2c6.8-24.4%2c17.8-30.8l98.8-57.1c11-6.4%2c24.5-6.4%2c35.5%2c0l98.8%2c57.1 c11%2c6.4%2c17.8%2c18.1%2c17.8%2c30.8v114.1c0%2c12.7-6.8%2c24.4-17.8%2c30.8l-98.8%2c57.1C1141.9%2c910.8%2c1128.4%2c910.8%2c1117.4%2c904.4z M1328.4%2c1306.9 c0%2c8.1-4.3%2c15.7-11.4%2c19.7l-48.2%2c27.8c-7%2c4.1-15.7%2c4.1-22.8%2c0l-48.2-27.8c-7-4.1-11.4-11.6-11.4-19.7v-55.7 c0-8.1%2c4.3-15.7%2c11.4-19.7l48.2-27.8c7-4.1%2c15.7-4.1%2c22.8%2c0l48.2%2c27.8c7%2c4.1%2c11.4%2c11.6%2c11.4%2c19.7V1306.9z M1295%2c1172.4l-94.7-54.7 c-11-6.3-17.8-18.1-17.8-30.8V977.6c0-12.7%2c6.8-24.4%2c17.8-30.8l94.7-54.7c11-6.4%2c24.5-6.4%2c35.5%2c0l94.7%2c54.7 c11%2c6.4%2c17.8%2c18.1%2c17.8%2c30.8v109.4c0%2c12.7-6.8%2c24.4-17.8%2c30.8l-94.7%2c54.7C1319.5%2c1178.8%2c1306%2c1178.8%2c1295%2c1172.4z M1580%2c1300.8 c0%2c9.3-5%2c17.9-13%2c22.5l-77.6%2c44.8c-8.1%2c4.6-18%2c4.6-26%2c0l-77.6-44.8c-8.1-4.6-13-13.2-13-22.5v-89.6c0-9.3%2c5-17.9%2c13-22.5l77.6-44.8 c8.1-4.6%2c18-4.6%2c26%2c0l77.6%2c44.8c8.1%2c4.6%2c13%2c13.2%2c13%2c22.5V1300.8z M1748%2c1073.9c0%2c12.7-6.8%2c24.4-17.8%2c30.8l-91.5%2c52.8 c-11%2c6.4-24.5%2c6.4-35.5%2c0l-91.5-52.8c-11-6.3-17.8-18.1-17.8-30.8V968.3c0-12.7%2c6.8-24.4%2c17.8-30.8l91.5-52.8 c11-6.4%2c24.5-6.4%2c35.5%2c0l91.5%2c52.8c11%2c6.4%2c17.8%2c18.1%2c17.8%2c30.8V1073.9z M1753.1%2c885.5l-94.6-54.6c-11-6.4-17.8-18.1-17.8-30.8 l0-109.2c0-12.7%2c6.8-24.4%2c17.8-30.8l94.6-54.6c11-6.4%2c24.5-6.4%2c35.5%2c0l94.6%2c54.6c11%2c6.4%2c17.8%2c18.1%2c17.8%2c30.8v109.2 c0%2c12.7-6.8%2c24.4-17.8%2c30.8l-94.6%2c54.6C1777.6%2c891.9%2c1764.1%2c891.9%2c1753.1%2c885.5z'/%3e%3c/svg%3e");
    {% elseif mask_type == 'wave' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cpath d='M508.5%2c2.9c0%2c0%2c431.9%2c192.1%2c511.8%2c471.7c79.9%2c279.5%2c163.6%2c427.8%2c359.5%2c497c247%2c87.3%2c465.9%2c368.8%2c514.7%2c468.4 h25.5V2.9H508.5z'/%3e%3cpath d='M899.7%2c968.3c-79.9-279.5-163.6-427.8-359.5-497C293.3%2c384%2c74.3%2c102.5%2c25.5%2c2.9H0V1440h1411.5 C1411.5%2c1440%2c979.6%2c1247.9%2c899.7%2c968.3'/%3e%3c/svg%3e");
    {% elseif mask_type == 'abstract_polygon' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cpolygon points='0%2c587.1 132.9%2c720 0%2c852.9 0%2c1079.9 359.9%2c720 0%2c360.1 '/%3e%3cpolygon points='0%2c0 0%2c133.2 586.8%2c720 0%2c1306.8 0%2c1440 93.8%2c1440 813.8%2c720 93.8%2c0 '/%3e%3cpolygon points='389.9%2c1440 616.9%2c1440 960%2c1096.9 1303.1%2c1440 1530.1%2c1440 960%2c869.9 '/%3e%3cpolygon points='843.8%2c1440 1076.2%2c1440 960%2c1323.8 '/%3e%3cpolygon points='1303.1%2c0 960%2c343.1 616.9%2c0 389.9%2c0 960%2c570.1 1530.1%2c0 '/%3e%3cpolygon points='843.8%2c0 960%2c116.2 1076.2%2c0 '/%3e%3cpolygon points='1560.1%2c720 1920%2c1079.9 1920%2c852.9 1787.1%2c720 1920%2c587.1 1920%2c360.1 '/%3e%3cpolygon points='1826.2%2c0 1106.2%2c720 1826.2%2c1440 1920%2c1440 1920%2c1306.8 1333.2%2c720 1920%2c133.2 1920%2c0 '/%3e%3c/svg%3e");
    {% elseif mask_type == 'arrow' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cpath d='M345%2c1044l78.9-136.6h54.5L399.5%2c1044l126.2%2c218.7h-54.5L345%2c1044z M443.7%2c1044l78.9-136.6h54.5L498.2%2c1044 l126.2%2c218.7H570L443.7%2c1044z M542.4%2c1044l78.8-136.6h54.5L596.9%2c1044l126.2%2c218.7h-54.5L542.4%2c1044z M0%2c0v1440h867.2l-229.3-397.2 L1239.9%2c0H0z'/%3e%3cpolygon class='st0' points='1727.4%2c1187.1 1873.5%2c1440 1920%2c1440 1920%2c853.5 '/%3e%3c/svg%3e");
    {% elseif mask_type == 'blobs' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cpath d='M245.6%2c1192.7c-9-24.7-23-53.5-34.6-76.1c-11.5-22.6-20.5-39.1-20.5-54.9c0-15.8%2c9-30.9%2c26.9-40.5 c17.9-9.6%2c44.8-13.7%2c70.4-19.9c25.6-6.2%2c49.9-14.4%2c65.9-27.4c16-13%2c23.7-30.9%2c23.7-46.6c0-15.8-7.7-29.5-17.9-41.8 c-10.2-12.3-23-23.3-50.6-45.9c-27.5-22.6-69.8-56.9-94.1-88.5c-24.3-31.5-30.7-60.3-32-85c-1.3-24.7%2c2.6-45.3%2c7.7-59 c5.1-13.7%2c11.5-20.6%2c42.9-36.3c31.4-15.8%2c87.7-40.5%2c119-77.5c31.4-37%2c37.8-86.4%2c33.9-128.9s-17.9-78.2-32-97.4 c-14.1-19.2-28.2-21.9-43.5%2c4.1c-15.4%2c26.1-32%2c80.9-48.6%2c105.6c-16.6%2c24.7-33.3%2c19.2-59.5%2c2.1c-26.2-17.1-62.1-45.9-83.2-76.8 c-21.1-30.9-27.5-63.8-28.2-81.6s4.5-20.6%2c12.8-24.7c8.3-4.1%2c19.8-9.6%2c28.2-18.5c8.3-8.9%2c13.4-21.3%2c16-51.4 c2.6-30.1%2c2.6-78-1.3-110.9c-0.6-5.3-1.3-10.3-2.3-14.9H0v1440h0.3c11.1-25%2c21.5-47.6%2c35.3-66.9c14.3-20%2c32.2-36.4%2c64.8-46.7 c32.6-10.3%2c80-14.4%2c109.4-24.7s41-26.7%2c44.8-45.3C258.4%2c1238%2c254.6%2c1217.4%2c245.6%2c1192.7'/%3e%3cpath d='M1819.2%2c1119.4c-19.6%2c28.1-18.4%2c81.6-35.6%2c112.5c-17.3%2c30.9-53.1%2c39.1-90.9%2c30.2c-37.8-8.9-77.4-35-125.4-39.1 c-48-4.1-104.3%2c13.7-161.3%2c26.1s-114.6%2c19.2-151.7%2c13.7c-37.1-5.5-53.8-23.3-73.6-45.3c-19.8-21.9-42.9-48-75.5-72.7 c-32.6-24.7-74.9-48-110.7-56.2c-35.8-8.2-65.3-1.4-76.2%2c11.7c-10.9%2c13-3.2%2c32.2%2c0%2c65.8c3.2%2c33.6%2c1.9%2c81.6-10.9%2c113.1 s-37.1%2c46.6-83.2%2c44.6s-113.9-21.3-165.8-45.3c-51.8-24-87.7-52.8-124.8-76.1c-37.1-23.3-75.5-41.1-100.5-42.5 c-25-1.4-36.5%2c13.7-39.7%2c38.4c-3.2%2c24.7%2c1.9%2c59-2.6%2c78.9s-18.6%2c25.4-35.2%2c30.2c-16.6%2c4.8-35.8%2c8.9-54.4%2c21.3 c-18.6%2c12.3-36.5%2c32.9-45.4%2c52.9c-8.4%2c18.6-8.9%2c36.8%2c9.3%2c58.6H1920v-336.3c-1.8-0.8-3.6-1.5-5.4-2.1 C1879.4%2c1088.5%2c1838.8%2c1091.3%2c1819.2%2c1119.4'/%3e%3cpath d='M1708.7%2c0c-7.7%2c7.7-15.5%2c15.6-23.1%2c23.9c-69.1%2c74.7-131.8%2c173.3-165.1%2c237.7c-33.3%2c64.4-37.1%2c94.6-38.4%2c113.1 c-1.3%2c18.5%2c0%2c25.4%2c11.5%2c29.5c11.5%2c4.1%2c33.3%2c5.5%2c54.4%2c8.2c21.1%2c2.7%2c41.6%2c6.9%2c58.9%2c21.9c17.3%2c15.1%2c31.4%2c41.1%2c26.9%2c68.6 c-4.5%2c27.4-27.5%2c56.2-52.5%2c76.8c-25%2c20.6-51.8%2c32.9-71.7%2c53.5c-19.8%2c20.6-32.6%2c49.4-32.6%2c80.2s12.8%2c63.8%2c48%2c80.9 c35.2%2c17.1%2c92.8%2c18.5%2c131.2%2c26.1c38.4%2c7.5%2c57.6%2c21.3%2c46.1%2c36.3c-63.5%2c83.2-1150-99.6-914.1%2c99.2c51%2c43%2c128.6%2c87.8%2c183.7%2c91.9 c55%2c4.1%2c87.5-32.5%2c112.6-54.2s43.1-28.6%2c74.5-26.5c31.4%2c2.1%2c76.2%2c13%2c111.4%2c35c35.2%2c21.9%2c60.8%2c54.9%2c113.3%2c61.7 c52.5%2c6.9%2c131.8-12.3%2c181.1-33.6c49.3-21.3%2c68.5-44.6%2c97.3-51.4c28.8-6.9%2c67.2%2c2.7%2c84.5%2c26.7c17.3%2c24%2c13.4%2c62.4-9%2c83 c-22.4%2c20.6-63.4%2c23.3-77.4%2c32.9c-14.1%2c9.6-1.3%2c26.1%2c19.2%2c30.9c20.5%2c4.8%2c48.6-2.1%2c73.2-9.5c24.6-7.4%2c45.7-15.4%2c62.9-44.2 c17.3-28.8%2c30.8-78.4%2c54.2-103.9c14.4-15.7%2c32.5-22.2%2c50.4-66.8V0H1708.7z'/%3e%3cpath d='M495.9%2c145c42.9%2c30.1%2c92.8%2c32.8%2c133.8%2c25.3c41-7.5%2c73-25.4%2c108.8-40.5c35.8-15.1%2c75.5-27.4%2c127.4-10.3 c51.8%2c17.1%2c115.8%2c63.8%2c148.5%2c104.2c32.6%2c40.5%2c33.9%2c74.7%2c58.2%2c101.5c24.3%2c26.7%2c71.7%2c45.9%2c132.5%2c39.8c60.8-6.2%2c135-37.7%2c192-86.4 c57-48.7%2c96.6-114.5%2c119-163.8c18.6-40.9%2c25.3-70.4%2c13.5-114.9H382.4C418.3%2c59.3%2c453.7%2c115.4%2c495.9%2c145'/%3e%3c/svg%3e");
    {% elseif mask_type == 'circle_corner' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cpath d='M863.6%2c158.1c0-54.4%2c6.2-107.3%2c17.8-158.1H0v1440h1920V772.6c-103.1%2c58.8-222.4%2c92.4-349.5%2c92.4 C1180.1%2c865%2c863.6%2c548.5%2c863.6%2c158.1'/%3e%3c/svg%3e");
    {% elseif mask_type == 'circles' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cg%3e%3cpath d='M1810.8%2c269.4c-44.6%2c0-80.8%2c36.3-80.8%2c80.9s36.1%2c80.9%2c80.8%2c80.9c44.8%2c0%2c80.9-36.3%2c80.9-80.9 S1855.6%2c269.4%2c1810.8%2c269.4'/%3e%3cpath d='M646.9%2c1084.3c-56.7%2c0-102.7%2c45.9-102.7%2c102.7c0%2c56.7%2c45.9%2c102.7%2c102.7%2c102.7c56.7%2c0%2c102.7-45.9%2c102.7-102.7 C749.5%2c1130.2%2c703.6%2c1084.3%2c646.9%2c1084.3'/%3e%3cpath d='M145.8%2c402.5C145.8%2c315.1%2c83%2c242.3%2c0%2c226.8v351.3C83%2c562.7%2c145.8%2c489.9%2c145.8%2c402.5'/%3e%3cpath d='M1221.9%2c953.3c109.6%2c0%2c198.4-88.8%2c198.4-198.4s-88.8-198.4-198.4-198.4c-109.6%2c0-198.3%2c88.8-198.3%2c198.4 S1112.3%2c953.3%2c1221.9%2c953.3'/%3e%3cpath d='M650.8%2c694.8c38.9%2c0%2c70.4-31.4%2c70.4-70.3s-31.5-70.3-70.4-70.3c-38.7%2c0-70.3%2c31.4-70.3%2c70.3 S612%2c694.8%2c650.8%2c694.8'/%3e%3cpath d='M1710.2%2c1264.2c-146.6%2c0-265.4-118.9-265.4-265.4c0-2.3%2c0-4.5%2c0.1-6.8c-58.3%2c54.8-136.7%2c88.3-223%2c88.3 c-179.7%2c0-325.4-145.7-325.4-325.4c0-114.7%2c59.3-215.5%2c148.9-273.5c-17.9%2c1.8-36%2c2.7-54.4%2c2.7c-281.5%2c0-513.6-211.5-546-484.4H0 v111.7c146.4%2c16.4%2c260.2%2c140.5%2c260.2%2c291.2S146.4%2c677.3%2c0%2c693.6v333.9c114.8%2c100.4%2c187.5%2c247.7%2c188.1%2c412H1920v-278.4 C1871.5%2c1223.8%2c1795.5%2c1264.2%2c1710.2%2c1264.2 M650.8%2c509.2c63.8%2c0%2c115.5%2c51.6%2c115.5%2c115.3s-51.7%2c115.3-115.5%2c115.3 c-63.6%2c0-115.3-51.6-115.3-115.3S587.1%2c509.2%2c650.8%2c509.2 M646.9%2c1355.4c-93%2c0-168.5-75.5-168.5-168.5c0-93%2c75.5-168.5%2c168.5-168.5 s168.5%2c75.5%2c168.5%2c168.5C815.4%2c1280%2c739.9%2c1355.4%2c646.9%2c1355.4'/%3e%3cpath d='M1230.1%2c429.3c176.1%2c4.4%2c317.4%2c148.4%2c317.4%2c325.5c0%2c12.1-0.7%2c24-1.9%2c35.7c45.2-35.9%2c102.4-57.3%2c164.7-57.3 c85.4%2c0%2c161.3%2c40.3%2c209.8%2c103V425.8c-24%2c34.6-63.9%2c57.3-109.2%2c57.3c-73.2%2c0-132.6-59.5-132.6-132.8c0-73.3%2c59.5-132.6%2c132.6-132.6 c45.2%2c0%2c85.2%2c22.6%2c109.2%2c57.2V142.9c-25.9-41-40.9-89.6-40.9-141.7v-1.7h-342.3C1514.3%2c189.3%2c1395.2%2c349.4%2c1230.1%2c429.3'/%3e%3cpath d='M990.9%2c269.3c162.6%2c0%2c298.2-115.9%2c328.7-269.7H662.1C692.5%2c153.3%2c828.2%2c269.3%2c990.9%2c269.3'/%3e%3cpath d='M1710.2%2c1160.5c89.3%2c0%2c161.7-72.4%2c161.7-161.7c0-89.4-72.4-161.9-161.7-161.9c-89.4%2c0-161.9%2c72.4-161.9%2c161.9 C1548.3%2c1088%2c1620.7%2c1160.5%2c1710.2%2c1160.5'/%3e%3c/g%3e%3c/svg%3e");
    {% elseif mask_type == 'creative' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cg%3e%3cpath d='M1505.4%2c317c160.2%2c0%2c292-138.8%2c308.4-317H0.2v1440H588c26.6-138.5%2c133.7-242.7%2c262.7-244.7 c114.2-1.8%2c206-108.2%2c206-238.8V829.9C1056.7%2c546.7%2c1257.6%2c317%2c1505.4%2c317L1505.4%2c317z'/%3e%3cpath d='M1766%2c1310.6c-95.1%2c0-178%2c52.2-221.7%2c129.4h375.9v-181.4C1877.4%2c1291.2%2c1824%2c1310.6%2c1766%2c1310.6L1766%2c1310.6z'/%3e%3cpath d='M1910.2%2c1211.1c-15.8%2c16.2-36.2%2c29.3-60.7%2c39.1c-31.1%2c12.4-68.8%2c19.4-112.1%2c20.7 c-44.5%2c1.3-86.8%2c13.7-125.8%2c36.7c-30.9%2c18.3-59.7%2c43.2-85.6%2c74.2c-17.2%2c20.6-30.8%2c41-40.9%2c58.3h26.8c8.6-13.6%2c19.1-28.6%2c31.7-43.6 c24.2-29%2c51-52.2%2c79.7-69.2c35.6-21%2c74.2-32.3%2c114.8-33.5c46.6-1.4%2c87.3-9.1%2c121.2-22.8c23.8-9.7%2c44.2-22.3%2c60.9-37.7v-33.6 C1917.2%2c1203.4%2c1913.9%2c1207.3%2c1910.2%2c1211.1'/%3e%3c/g%3e%3c/svg%3e");
    {% elseif mask_type == 'diagonal' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cg%3e%3cpolygon points='1149.1%2c0 0%2c0 0%2c1440 686.1%2c1440 '/%3e%3c/g%3e%3cpolygon points='1574.1%2c1440 1920%2c1440 1920%2c364.4 '/%3e%3cg%3e%3cpolygon points='1574.1%2c1440 1920%2c1440 1920%2c364.4 '/%3e%3c/g%3e%3c/svg%3e");
    {% elseif mask_type == 'hexagon_corner' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cpath d='M1867.9%2c1262.8l-809.1%2c0c-80.2%2c0-154.3-42.8-194.4-112.2L459.9%2c449.9c-40.1-69.4-40.1-155%2c0-224.4L590.1%2c0H0 v1456h1920v-199.3C1903.1%2c1260.7%2c1885.7%2c1262.8%2c1867.9%2c1262.8z'/%3e%3c/svg%3e");
    {% elseif mask_type == 'hexagons' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cpath d='M902.5%2c1064.4l-6.2-10.8l6.2-10.8l123.7-214.3h259.9l130%2c225.1l-130%2c225.1h-259.9L902.5%2c1064.4z M1308.1%2c818.4 l130-225.1H1698l130%2c225.1l-130%2c225.1H1438L1308.1%2c818.4z M900.2%2c578.7l130-225.1H1290l130%2c225.1l-130%2c225.1h-259.9L900.2%2c578.7z M1311.9%2c344.2l130-225.1h259.9l130%2c225.1l-130%2c225.1h-259.9L1311.9%2c344.2z M0%2c0v1440h1920V804.8h-66.2l-127.3-220.6l127.3-220.6 h66.2V0H0z'/%3e%3cpolygon points='902.5%2c1042.7 896.3%2c1053.5 902.5%2c1064.4 '/%3e%3c/svg%3e");
    {% elseif mask_type == 'hive' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cpath d='M1016 1164.6l73.6-127.4H1237l73.7 127.4L1237 1292h-147.3l-73.7-127.3zm514.3 0l73.7-127.4h147.3l73.6 127.4-73.6 127.3H1604l-73.7-127.3zm-257-148.2l73.6-127.3H1494l73.6 127.3-73.6 127.3h-147.3l-73.6-127.3zM1016 868.2l73.6-127.3H1237l73.7 127.3-73.7 127.4h-147.3L1016 868.2zm514.3 0L1604 741h147.3l73.6 127.3-73.6 127.4H1604l-73.6-127.4zm-257-148.2l73.6-127.3H1494l73.6 127.3-73.6 127.3h-147.3L1273.2 720zm257-148.2l73.6-127.3h147.3l73.6 127.3-73.6 127.3H1604l-73.6-127.3zm-257-148.2l73.6-127.3H1494l73.6 127.3L1494 551h-147.3l-73.6-127.4zm-257.2-148l73.6-127.3H1237l73.7 127.3-73.7 127.3h-147.3L1016 275.5zm514.3 0l73.7-127.3h147.3l73.6 127.3-73.6 127.3H1604l-73.7-127.3zM1812.7.1l-61.5 106.3H1604L1542.4.1H1494l73.6 127.2-73.6 127.3h-147.3l-73.6-127.3L1346.8.1h-48.3L1237 106.4h-147.3L1028.2.1H980l73.6 127.2-73.7 127.3H832.6L759 127.3 832.5.1H0v1440h832.5L759 1312.8l73.7-127.3H980l73.7 127.3L980 1440h48.3l61.5-106.3H1237l61.5 106.3h48.3l-73.6-127.2 73.6-127.3H1494l73.6 127.3L1494 1440h48.3l61.5-106.3h147.3l61.5 106.3h48.3l-73.6-127.2 73.6-127.3h59v-41.7h-59l-73.6-127.3 73.6-127.3h59v-41.7h-59L1787.4 720l73.7-127.3h59V551h-59l-73.6-127.3 73.6-127.3h59v-41.7h-59l-73.6-127.3L1861 .1h-48.3z'/%3e%3c/svg%3e");
    {% elseif mask_type == 'organic' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cpath d='M879.7 648.2c35-6 72.5-6.3 103.6-23.7 71.2-40 81-154.3 158.5-180.5 38-12.8 80 1 119.4-6 46.2-8.2 88.4-40.3 109.7-82 101.8-200 216.5-284.2 468-303.8 27.3-2 56-.6 81 10V0H0v1440h1920v-162.6c-32.3 25.6-76 41-117 39.7a275 275 0 0 0-83.7 9.7c-78 22-166.3 8-232.3-39.5-30.5-22-57.5-50.7-86.2-75.5s-59-45.5-96-51.2c-29-4.4-58.4 1.3-87.7 2.8-50.3 2.5-93.2-15.2-108.7-66.2-6.5-21.4-8-44-11.8-66-8-47-31.6-83.8-82-87.3-41.3-3-88.7 13.6-123.8-16.4-28-24-27.4-67.8-46.4-99-6.3-10.3-12-21-16.4-32.2l-26-65.7c-6.4-16-3.3-34.3 8.2-47.2 17-19.4 45.3-31 69.6-35.4'/%3e%3c/svg%3e");
    {% elseif mask_type == 'pointer' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cpath d='M1919.5 440V308l-22.6 33-248 367.8 270.7 401v-111l-184-289.5z'/%3e%3cpath d='M1919.5 998.7h0v111l.5.8v-111h0v-50l-.5-.8zm0 137l.5.8v-26l-.5-.8z'/%3e%3cpath d='M1919.5 308v132h0v43.7h0l-153.2 224 153.2 241h0l.5.8V922l-.5-.8h0l.5.8V509l-.3.4.3-.4v-26l-.3.4.3-.4v-43.7h0v-132l-.5.7zm0 202.2v411.3l-135.4-213L1919.5 510zM1428 0h-18L935.4 703.5l468.2 736.5h17.4L953 704zm-60.7 0H0v709 731h1359.5L892 704.5zm120.5 0l-480 702.5 468.8 737.5h87l-467.3-735L1578 0z'/%3e%3c/svg%3e");
    {% elseif mask_type == 'psychedelic' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cg%3e%3cpath d='M1920.2 1440v-22.5L1895 1440h25.2zm-68.2 0a823 823 0 0 1 68.1-58.9v-35c-39.2 27.7-76.6 58-110.8 94h42.7zm-120-4.8l-3.7 4.8h39.5c45-52.4 97.3-92.4 152.4-127.6V1280c-69.3 40-134.8 86.2-188.2 155.3M.2 1419.4c39.6 4 79.2 10.8 118.4 20.6H266A758 758 0 0 0 .2 1377v42.4z'/%3e%3cpath d='M1707.2 1366.8a813 813 0 0 0-54 73.2h37a761 761 0 0 1 29.2-39c56.7-70.5 127-114.5 200.6-152.4v-30.3c-77.8 35.8-152.7 76.8-213 148.5M.2 0v4.4L4.4 0H.2z'/%3e%3cpath d='M.2 1299v37.8h13.3C135.5 1338 260 1374 370 1440h84.3c-121-91.6-267-143.5-409.6-143l-44.6 2m1580.3 141h36.5c24-38 49.3-74.6 78-107.3 63.6-72.7 143.4-110.3 225.3-143.8v-28.4c-86 31-170.4 64.6-237.6 138-38.4 42-70.6 90.8-102.2 141.5M17.6 0L.2 18.5V33L30.5 0h-13zm1485.6 1440h39.7c40-63 78.8-125.2 127.3-175.7 71-73.8 160.3-103 250-131.3v-26.7c-93.4 25.7-187.6 50-262.3 123.8-59.3 58.7-104 135.8-154.7 210'/%3e%3cpath d='M107.6 1217.8c-37 1.3-72.6 7.2-107.4 14v32l76-6.5c152-3 307.7 60.3 431.6 166l19 16.7h65.5l-63-58.8c-121-103.8-273-168.6-421.8-163.4M55.8 0H43.3L.2 47.8v15l8.4-10a1042 1042 0 0 1 47.2-53m1577.4 1162c-74.7 66.2-127 164.2-197.7 247l-28 31.3h51.5c65-83 115.4-177.4 186.4-244 77.8-73 175.4-92.2 271.5-114.8 1-.3 2-.5 3.2-.7v-25l-13 2.4c-96.5 18.8-195 33.6-274 104m-1462.8-23.5c-60 4-115.5 22.8-170 37.4v26.7l138.7-24.4c145.7-7.5 294 59 412 161 36.2 31.2 70.4 66 104.4 101h64.4c-48.7-47.4-96-98.8-147.2-143-115.3-100-260-168.2-402.3-158.4M50.4 33a948 948 0 0 1 30-33H68.2L29.5 43 .2 76v12l50.2-55m42-20l12-13H92.5l-21 23L.2 100.7v15l9.8-12C37 72 64.7 44 92.3 13m1516.2 1080.5c-70.4 55-122.3 140-188.2 212.8-46 50.7-97.5 99.2-153.8 133.7h79.8c29-25.5 56.2-53.6 81.6-82.5 68.3-77.7 120.4-169.3 193-229.8 80.8-67.4 179.8-78 276.8-93.2 7.5-1.2 15-2.3 22.5-3.4v-23.5l-32.2 3.5c-97.6 11.3-197 18-279.5 82.4M233 1059.2c-83.7 8.8-156.6 51-232.8 67.6v24.2l201.4-52c139.2-12 280 57.7 392.6 156 67.3 58.7 129 129.3 196 185.2h88c-95.4-53.8-174.8-150-262.6-227.3-109.6-96.5-246.8-168-382.8-153.6m1351-34.3c-66 44.3-117.6 116-178.8 178.8s-130.2 123-206.3 152c-69.5 26.7-138.8 24.5-210 10-128.2-26.3-225-144-329.7-237.3-104-93-233.8-167.4-363.4-148.6-105 15.2-190 92.4-291.3 94.4h-4v27.5c88.7-11.3 168.8-70.3 264-82.2 132.8-16.6 266.3 56.4 373 151C745 1266 842 1388.5 972.6 1419c74.6 17.5 148 23.6 222-3 81.2-29 154.4-93.2 218-161 63.6-67.7 115.3-146.2 183.5-195.8 84-61 184-64.2 282-71.5l42-3v-22l-51.6 1.6c-98.3 3.5-198.8 3-284.6 60.7M127.8 0h-11.6l-3 3-80.6 89.6A735 735 0 0 0 .2 134.7v25l55-78.3C78.5 52.4 103 26.6 128 0m1227.8 5.2l18.3-1 44-4.3h-170.3a667 667 0 0 0 108 5.2M150.4 0H139L77.6 70C47.4 108.5 21.2 150.3.1 194.8v57a610 610 0 0 1 100-192.9l50.3-59m1408.6 957c-61.5 34.2-112.8 92-169.3 144.7-56.5 52.8-117.2 105-183 134.2-60.4 27-121.6 32.6-185.6 23.6-123.7-17.4-220-125.4-318.8-215-98.3-89.3-220.7-167-344-143.7-101.6 19-181 105.7-280.5 114.8a167 167 0 0 1-77.7-11.2v38a169 169 0 0 0 41 2.6c100.4-5.6 182.6-87.4 286-104.6 126.4-21 252.5 55 353.6 146 101.7 91.5 198.3 204.2 324.3 226 67.5 11.8 132.8 10 197.7-16.7 71-29 136-85.3 194.7-143s110.3-122.6 174-161.8c87.7-54 188.5-50 287.5-50l61.2.3v-20.8l-71-3c-99.4-3.8-200.5-10.6-290 39.3M54.5 232a554 554 0 0 1 90.8-195.8L174 0h-12l-39.2 47.6C79.5 105.6 46 172 26.8 244L.2 359.3v81.4c14.4-28.6 23.5-60 30.7-92L54.5 232M1830 871c-100.4-11.6-202-23-295.5 17.4-57.2 24.8-108 68-160 110.7-51.7 42.8-104 87-159.8 116.3-51.3 27-104.2 41-161.3 37.3-119-7.8-215.2-107-308-192.6C653 874.5 538 794.2 421 821.4 323 844.6 249 940 151.2 956.7c-42.3 7.2-82-3-117.3-24.8A233 233 0 0 1 .1 906.1v53.3a170 170 0 0 0 114.4 26.8c98.8-13 175.4-104 275.2-125C509.7 836 628.4 915 724 1002.4c95.7 87.6 192 191 313.4 203.8 60.5 6.3 117.6-3.4 173.4-30.4 60.8-29.3 117.4-77.5 171.4-125.2 54-47.8 105.3-98.3 164.6-127.7 91.6-45.4 193-36 292.8-28.2l80.6 6V881l-7-.6-83.3-9.5M1345 68.8l17.2-1.4c84-8.3 164-39.4 243.7-67.4h-62.5L1368 35.8l-17.7 1c-81.8 4-160.2-12-236.7-37H1046c96.3 43.3 194.6 75 299 69M1910.3 0l10 3.5V0h-10zM64 441c48.7-63.3 51.3-151 68.5-228.2a497 497 0 0 1 44.3-121.1A509 509 0 0 1 238.2.1h-51.7A529 529 0 0 0 82.2 220.2C65 302 63 395.3 12 462A349 349 0 0 1 .2 476.5v36C18 488.3 42.6 468.8 64 441m1269-330.8C1453.5 102.8 1565 34 1681 0h-34c-101.3 39-201 93-307.3 100.6C1220.4 109.2 1110.2 60 1001 0h-14c111.6 62.8 224 117.7 346 110.2m189.4 726.2c-73.5 26-138.5 77.4-204 125.2-73 53.4-146.7 101.4-233 98.8a252 252 0 0 1-103.5-27.2c-68.6-33.4-130.3-92-189.3-146-87.2-79.6-194.5-157.7-304-131-57.6 14-106 55-157 88.4-31 20.5-63 38-98.5 44.8-53 10.2-102.3-8.5-143.2-43.7C51.2 812.3 20 764.3.2 712.2v130.4c48.3 61.4 114.5 100 188 84.7 97-20.3 168.2-120.5 264.4-145.5 113.7-29.6 225 52.4 314.7 136.2s185.8 179 302.5 181.5c169.7 3.8 291-186 452.5-245.2 122-44.8 254-11 381.7 5.7l16.4 2v-15.4a719 719 0 0 1-36.3-3.9c-121-15.7-245.8-47-361.6-6.3'/%3e%3cpath d='M1326.5 119.8C1202 126 1088.2 65 974.2 0h-13C1077.6 66.8 1193 134.2 1320 129.4c148.2-5.6 282.5-110.7 431.7-105 59 2.3 115.8 19.2 168.6 47v-35a372 372 0 0 0-140-33.7c-157-5.3-297.7 109.2-453.7 117m196.4 681c-68 21.6-128.4 61.5-189.5 101-68 44-137 84.2-216.6 80.6a246 246 0 0 1-95.9-25.5c-64-30.4-121.8-82.8-177.4-131-82-71.4-181.5-141.4-283-121-53.3 10.7-98.7 45-146 72.5-29 17-58.7 31.2-91.4 36-48.8 7.3-94-10.6-131.8-43.5-62.4-54.6-102.4-151-103-235-.4-69 44-90.2 79.7-136 43.8-56.3 48-133.5 65-200.8A436 436 0 0 1 275 92.4 448 448 0 0 1 343.3.1h-52.7C265.8 27.8 244 58.7 226 92a467 467 0 0 0-43 113.4C166 277.6 162.4 360 116.2 420 78.4 468.6 30.8 490.6 32 564c1.3 87.5 43.6 187.5 108.7 244 39.3 34 86.5 52.3 137.5 43.6 34-5.8 65-21.8 95-40.4 49.2-30.5 96-68 151.5-80.5C630 707 733.4 781 818 856.5c57.3 51 117 106.6 183.3 138.6 31.6 15.2 64.7 25 99.7 26.3 83 3 154.3-41 224.8-89.7 63.4-43.6 126-89.4 196.8-113 109.5-36.7 227.2-8 341.3 6.8l56 5v-17l-76-5.4c-107.3-14-218-40.3-321-7.5'/%3e%3cpath d='M1313.2 139c-129 3-246-71.2-365-139H935c121.6 67.8 240 149.7 371.5 148.6 132.7-1 253.7-87.5 388-81a435 435 0 0 1 203 63.5 460 460 0 0 1 22.8 14.5v-38C1859.5 71.4 1793 49 1723.2 46c-142-6-269.5 89.7-410 93m491.3 634.5c-94-12-190.4-33.5-280.8-8.6-62.6 17.3-118 45.8-175 77-63 34.4-127 67-200.3 62.4a246 246 0 0 1-88.4-23.7C1000.8 853 946.6 807 894.5 764.2c-77-63-168.5-125-261.7-110.8-49 7.5-91.3 35-135.3 56.6-26.8 13.3-54.4 24.4-84.3 27.3-44.6 4.5-86-12.8-120.4-43.4-57-51-92.7-140-91.4-217.6 1-60.3 39.2-80 70.8-120 39-49.4 44.8-115.8 61.5-173.4A376 376 0 0 1 373 93a395 395 0 0 1 78.3-93h-54.6a423 423 0 0 0-72.8 92.7c-17.4 30.2-31.3 63-40.5 97.6-16.8 62.4-22 134.2-63.3 187-33.6 43-75 63.5-75.2 128-.4 80.8 37.4 173.5 97.2 226.3 36 31.8 79.4 49.4 126 43.5 31.3-4 60-16.6 88-31.7 45.7-24.6 89.6-55.4 140.7-64.5 97.2-17.2 192.7 49 272.2 116 54 45.5 110 94.8 171.4 123.7 29.3 13.8 60 22.8 92.2 24.6 76.5 4.2 143-32.3 208.4-71.5l182.3-89c96.8-28.8 200.3-5 301 8a565 565 0 0 0 95.8 4.6v-19.7c-38.2 4.4-78 2.6-115.6-2.2'/%3e%3cpath d='M1666 89.3c-126.6-7-241 70-366 69-134-1.3-254-92-379-158.3h-16c129.3 63 251.2 164 388.6 167.8 117 3.5 225-64.2 344-57 68 4.2 133.5 22.4 194 54.4 31.3 16.5 61.4 37 89 61.5V185a463 463 0 0 0-55.8-36.8 456 456 0 0 0-198.6-59m98.6 649.8c-80.7-10-163-27.2-240.5-9.7-57.4 13-108 30-160.4 52.7-58 25-117.2 50-184 44.2a250 250 0 0 1-81-22c-54.5-24.5-105-64.3-153.6-101.4C873.7 648 790 593.8 705 602c-44.7 4.3-84 24.8-124.6 40.6-24.7 9.7-50 17.6-77.2 18.6-40.3 1.5-77.8-15-109-43.3-52-47.4-83-129-80-200 2.3-51.6 34.4-69.6 62-104 34-42.4 41.6-98 58-146a320 320 0 0 1 36.7-74.1c25-37.6 58-69.6 95-93.7h-58.7c-33.3 25.5-62.5 57.2-85.5 93.4-16 25.2-29 52.7-38 82C367.3 228 360.6 289 324 335c-29.6 37.3-64.7 56.2-66.4 112-2.2 74.2 31.2 159.6 85.7 208.8C376 685.4 415.5 702 458 699.2c28.6-2 55-11.5 80.8-23 42.3-18.8 83-42.7 130-48.6 89-11.3 176.8 46.8 251 105.7 50.4 40 102.7 83 159.5 108.8A248 248 0 0 0 1164 865c70 5.2 131.7-23.6 192-53.3 55-26.7 108-49.5 168-64.6 84-21.2 173.3-2 260.7 9 44.4 5.6 91.6 6.7 135.5-2.5V728c-48.4 17-104 17.2-155.4 10.8'/%3e%3cpath d='M1608.8 132.6c-111.5-7.6-212.7 50.6-322 45C1145 170.2 1020.2 56.2 884.6 0h-31.4c147.2 41.3 277.2 175.5 427 187 101.5 8 196.2-40.7 300-33 64 4.8 126.6 18.7 185 45.3 50.3 22.8 98.4 56.3 136 101.5l16 20.7 3 4.4V272c-35.4-38-77.7-68.2-122-90-59.4-29.2-123.5-45.3-189.5-49.7M1916.4 657c-49 50.7-124 55.7-191.3 47.5s-135.8-21.3-200.2-11c-52.2 8.4-97.7 14.3-146 28.5-52.8 15.6-107.4 32.8-167.7 26a260 260 0 0 1-73.3-20.2c-49.8-21.5-96.4-55-141.7-86.6-66.6-46.5-142.5-92.6-219.3-90.5-40.4 1-76.6 14.7-113.8 24.7-22.6 6-45.7 10.7-70.2 10-36-1.3-69.7-17-97.6-43.2A240 240 0 0 1 427 359.6c3.4-43 29.5-59.4 53-88 29-35.4 38.3-80.4 54.5-118.6a268 268 0 0 1 34.2-58.4c35-45 83-78.3 136.3-94.6h-75.5a306 306 0 0 0-109.7 94c-14.4 20.2-26.4 42.5-35.4 66.3-16.3 43-24.7 93.4-56.2 132.3-25.6 31.6-54.7 49-57.5 96-4 67.6 25 145.7 74.2 191.3 29.5 27.3 65 43.4 103.3 43.3 25.8-.1 50-6.3 73.7-14.2 39-13 76.6-30 119.2-32.7 81-5.2 160.7 45 230 95.6l147.7 94a247 247 0 0 0 77 21c63.5 6.3 120.5-14.8 175.8-35 50.4-18.5 98.4-30 153.2-40.6 71-14 146.4 1.2 220.4 10.3 59.3 7.3 124.3 5.3 175.2-25v-44l-4 4'/%3e%3cpath d='M1866.2 311.3c-37-43.3-84.8-74.3-134.2-94.8-57.2-23.8-118-35.5-180.4-40.7-96.4-8-184.4 31-278 21-148.2-16-276.4-155-424.8-184.6-87-17.4-175.3 17.7-231 82.7a239 239 0 0 0-32.9 50.6c-16 33.4-26 73-52.7 105-21.5 26-44.8 41.6-48.7 80-6 61 18.7 131.8 62.7 173.7 26.3 25 58 40.4 92 43a237 237 0 0 0 66.6-5.5L813 525c72.7 1 144.7 43 208.7 85.4 43.6 28.7 88.3 59 135.8 79a271 271 0 0 0 69.5 19.4c57 7.4 109.3-6 159.5-16.8 46-10 89-10.3 138.6-16.4 57.8-7 119.4 4.2 180 11.5s128 2.7 172.4-42c25-25 35.8-60.2 42.4-96.2V419c-7-31.4-19.6-61.8-38.3-87.8l-15.5-20m17.6 214.3c-7.4 39.3-16.6 80.6-44.7 107.7-40.2 38.7-99.6 43-153.6 36.5-54-6.4-108.7-16-160-12-47.2 3.7-87.4-1.4-131.3 4.4-47.7 6.2-97.6 15.7-151.3 7.7-22.7-3.4-44.6-9.8-65.8-18.5-45.2-18.5-88-45.8-129.8-71.7-61.5-38.2-129.5-76.4-198-80.3-36-2-69.2 4.7-103 8.8a246 246 0 0 1-63.1 1.1c-31.8-4-61.5-19-86.2-43-41.4-40.2-64.2-107-57-165 4.3-34 24.7-49 44.2-72 24.2-28.5 35-62.8 51-91.3a209 209 0 0 1 31.6-42.7 225 225 0 0 1 210-63.5c136 30.7 254.4 155 390.2 174.6 86 12.5 167.4-17 256.2-8.8 60.3 5.6 119.7 15 176 36 48.6 18 96 46.6 132.3 88a264 264 0 0 1 15.4 19.2c38.3 52.5 48.6 124.7 37.2 184.8M1796.4 332c-35.8-39.7-82.8-65.6-130.5-81.4-55-18.4-113-25.5-171.3-31.6-81.3-8.4-156 11.6-234.3-3.2C1137 192.8 1028.2 83 904.6 51a208 208 0 0 0-188.8 44.4 185 185 0 0 0-30.4 34.9C669.6 154 658 183 636.3 208c-17.5 20-35.2 34.3-39.8 64a190 190 0 0 0 51.2 156.2 154 154 0 0 0 80.5 43 261 261 0 0 0 59.5 3.2c32-1 63.6-4.5 97.6-.8 64.5 7 128.6 41.2 187.5 75.2l124 64.3c20 8 40.7 14 62 17.6 50.5 8.5 98 3 143.2 1.4 41.8-1.4 79.2 8.8 124 7.7 44.5-1 92.5 7.2 139.7 12.6 47.3 5.4 99 1.6 134.8-31 25-23 34.3-58 42.6-91.7 14.4-58 5.8-128.8-31.5-179.4a251 251 0 0 0-15.1-18.4m5.8 202c-9 28-18.6 57-40.5 75.7-31.4 26.6-75.3 30-116 25.6L1526.3 622c-42.4-1.8-77-17-116.8-19.8l-135-10.5a343 343 0 0 1-58.2-16.7c-40.5-15.6-79.5-36.5-118-56.8-56.4-30-116.5-60-177-70.2-31.8-5.3-61.8-5.4-92.2-7.2-18.4-1-37-2.8-56-7.6a160 160 0 0 1-74.8-43c-36-36.5-55.3-96-45.4-147.4 5-25.4 20-38.8 35.4-56 19.3-21.5 31.7-45 47.4-64 8.6-10.3 18.4-19.4 29-27C811 63 873 53 932.7 70.7 1044 104 1143 199 1254 225.5c70.4 17 138.6 6.7 212.3 15.2 56.5 6.5 112.8 11.3 166.8 27 47 13.5 93.4 36.8 128.6 74.7a231 231 0 0 1 14.8 17.7c36.4 48.7 43.8 118.5 25.8 174m-75.8-181.5c-34.6-36-80.7-56.8-126.8-68-53-13-107.7-15.4-162.3-22.4-66.2-8.5-127.8-8-190.4-27.2-98.5-30.2-187.8-110.2-286.6-145-50.8-17.8-103.8-16-146.6 6a142 142 0 0 0-27.8 19.2c-15.6 14-28.8 32.2-45.7 50.2-13.4 14.4-26 27-31 48-11.4 48 6.3 104 39.7 138.6a167 167 0 0 0 69.1 42.9 344 344 0 0 0 52.4 12c28.7 4.7 57 8.2 86.8 15 56.3 13 112.6 39.3 166.4 65l112 49.4a421 421 0 0 0 54.5 15.9c44 9.6 87 12 127 19.6 37.5 7.2 69.5 27 109.5 32 31 4 65.6 10.2 99.4 13.8 34 3.6 70 .5 97-20 19-14.4 29-37.2 38.5-59.6a177 177 0 0 0-20.4-168.7l-14.8-17m-5.8 190c-9.7 17.3-20.6 33.5-36.4 43.6-22.7 14.6-51 17.2-78.2 14.6l-79.2-14.4c-37.4-9-66.8-32.4-102.2-44-37.4-12.2-78-18.6-118.7-28.7l-50.7-15-106-42c-51.2-21.6-103.5-44-155.8-60C966 388 939 381 912 373.5a438 438 0 0 1-48.9-16.3 181 181 0 0 1-63.4-42.8c-30.8-33-47.3-85.3-34-130 5-16.8 15-28.6 26.5-40 14.4-14.5 28.4-27.5 44-36.5a121 121 0 0 1 26.5-11.4c39.6-11.3 83.7-4.5 125.6 13.2 86.2 36.4 166 101.2 252 135 54.8 21.5 109.8 30.7 168.4 39.2l157.8 18c45.2 9 91 27 125 61.3 5 5 9.8 10.4 14.2 16.2 34.8 45 42.2 114.3 15 163.3m-187-224c-50.8-7.5-102.5-5-153.3-13.3-131.4-21.6-243.8-113-364-176.2-33-17.4-68-33-104.5-32.4-36.4.6-74.8 21-89.5 58.5-16 40.6.1 90 28.2 121s66 48 103 63.5l321.2 120.5 157.5 52c33.2 16 60.7 42 95 56 49.2 20.2 114.4 27.6 152.7-21.8 33.8-43.4 24.7-114.8-9.3-158s-86.2-62.5-137-70m120.4 212c-11.5 17.2-26.3 29.3-44 35a106 106 0 0 1-49.2 2.7c-16.6-2.8-32.7-8.7-47.4-15.4-30.3-13.7-55.4-36.6-85.2-51.2l-25.8-11.5-115-37.5-33.8-11.4-179.2-64-77-30.3c-33.4-13.6-67.6-28.5-93.3-56-25.8-27.5-41.2-71.5-27.3-108.3 10.3-27.5 35-45 61.3-51.4 6.4-1.5 13-2.4 19.4-2.6 33-1 65 12.6 95 28 108.6 56 209.3 139 327.2 159.5l12.4 2 125.4 10.8c24.7 3.6 49.7 10.2 72.4 21.4 19.4 9.6 37 22.6 51.5 40 31 38 39.8 99.7 12.8 140M1565 358.2c-20.3-9.6-42.5-15.3-64.4-18.4-37-5.3-74.5-4.7-111.4-10.3l-11-1.8c-104.6-19.5-193.6-94-290.4-142.8-27.2-13.6-56-25.2-85.8-24a86 86 0 0 0-17.4 2.5c-23.6 6-45.7 22-54.5 47-11.7 33 3 71.6 26.5 95.5 23.3 24 53.7 37 83.6 48.6l69 25.8 160 54.7 30 10.2 101.7 35.4 22.8 10.6c26.3 13.4 49 33 75.4 46.4 14 7 28.7 13.7 44.5 16.8s32.4 2.6 46.8-3.2c16.6-6.7 28.5-20.3 37.5-36.7 20.2-36.8 12-89.3-16.5-122-13-15-29-26.2-46.3-34.4m36.8 140.2c-6.6 15.8-15.5 30.7-31 38.3a68 68 0 0 1-44.4 3.7c-15-3.4-28.7-11-41.6-18.2-22.7-12.8-42.8-29.4-65.6-41.5a364 364 0 0 0-19.8-9.8c-28.7-13.6-58.8-22.8-88.3-33.3l-26.3-9-140.7-45.4-60.7-21.3c-26.3-9.8-53-21-73.8-41.2-21-20.4-35-53.4-25.6-82.7 7.2-22.3 26.8-37 47.7-42.4l15.4-2.5c26.3-1.7 52.2 7.8 76.4 19.6 85.2 41.3 162.4 107.6 253.6 126l9.6 1.8c32.2 5.3 65 5.2 97.3 9.8a207 207 0 0 1 56.5 15.5 128 128 0 0 1 41.1 28.8c25.6 27.3 33.8 71 20 103.8M1552 396.5a117 117 0 0 0-35.8-23.2 190 190 0 0 0-48.6-12.5c-27.8-4-55.8-4-83.3-9.3a239 239 0 0 1-8.2-1.7c-77.8-17.4-143.2-75.4-216.8-109.4-21.3-10-44-17.4-67-15.3-4.5.4-9 1.2-13.4 2.5-18 5-35.2 18.3-41 38-7.4 25.6 6 53.2 24.7 70 18.4 16.6 41.4 25.8 64 33.7L1179 386l121.5 36.2 22.6 8 74.8 31.2 16.7 9c19.3 11 37 24.6 56 36.7 12 7.7 24.6 16 38.7 19.6s29.8 3 42-4.2c14.2-8.4 20.2-24.4 24.3-40a92 92 0 0 0-23.8-86m-2.3 69.7c-1.2 15.3-4.7 32.2-17.6 41.5-11.2 8-26.4 8.8-39.6 4.7-13.3-4-24.7-12.8-35.8-21l-46-31.8-13.7-8a404 404 0 0 0-61.4-29.1l-19-6.7c-33.8-11-68.2-18.3-102.3-27l-44.2-12.3c-19.2-6-38.4-13.2-54.3-26.3-16.3-13.2-29-35.3-24-57.2 4-17 18.7-28.7 34-33.5 3.8-1.2 7.6-2 11.4-2.5 19.5-2.4 39.3 3 57.7 11 62 26.8 115.6 76.3 180 92.7a167 167 0 0 0 6.8 1.6c22.8 5 46 5.6 69.2 8.8 13.8 2 27.6 4.7 40.6 9.6 11 4 21.5 9.8 30.6 17.6a82 82 0 0 1 27.4 68m-56.7-66a95 95 0 0 0-25.4-11.9c-10.6-3.3-21.7-5.2-32.7-6.6l-55.2-8.3-5.4-1.5c-51-15.4-93-56.4-143.2-76-15.5-6-32.2-9.6-48.3-6.8a66 66 0 0 0-9.5 2.4c-12.6 4.4-24.7 14.6-27.3 29-3.2 18 9 34.7 23 44.4a138 138 0 0 0 44.6 18.8l36 7.8 83 17.7 15.2 5.5a237 237 0 0 1 47.9 26.9l10.6 7.3 36.3 27c10 8.8 20.5 18 33 22.4s27 3.6 37.2-5.2c11.7-10 13.2-28 11-43-2.7-19-13.4-38.2-30.8-49.8m.6 78.4c-9 9.5-23.2 10.4-34.8 5.7s-21.2-14.2-30-23.8c-10.7-11.6-23-18.2-34.2-28.6-14.3-13.4-27.6-23.7-46-29-20.7-6.2-42.4-6.8-63.8-8.5s-43.2-4.5-62.7-14.7c-11.5-6-23.2-17.3-22-31.6 1-11.8 10.6-20.5 20.5-24.5 14.8-6 31.3-4.8 46.4.2 39.7 13 70.8 47.2 110.3 60.7 21.3 7.3 44 7 66 11.4 22 4.6 44.7 15.8 54.8 38 6.5 14.4 6 33.7-4.4 44.7'/%3e%3c/g%3e%3c/svg%3e");
    {% elseif mask_type == 'puzzel' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cpath d='M1045 1440L916.2 423.3l722.2 43.8-253.6 973H1045zM1760.2 0L1645 442l-732-44.8L862.6 0h897.6H0v1440h1920-508.2l134.8-518.7 373.4 102v-26.7L1553.2 896l233-896h-26z'/%3e%3c/svg%3e");
    {% elseif mask_type == 'rectangles' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cpath d='M1386.3 454.5h291.2v782.8h-291.2V454.5zM1060 277h291.2v782.8H1060V277zM-209.7-170l.2 1730h2129.7l-.2-605.6h-207.4V171.6H1920V-170H-209.7z'/%3e%3c/svg%3e");
    {% elseif mask_type == 'slices' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cpath d='M1766.3 1185.5c-58.5 62-140.6 61-182.4-2s-28-165.3 30.4-227.2L1920 633v-25.7l-409.6 433.3c-58.5 62-140.6 61-182.4-2s-28-165.3 30.4-227.2l561.6-594v-33l-754.5 798.2c-57.3 60.6-137.6 59.7-178.5-2l-3.3-5c-41-61.7-27.5-161.7 29.8-222.3L1725.3 0H1699l-415.2 439.2c-57.3 60.6-137.6 59.7-178.5-2l-3.3-5c-41-61.7-27.5-161.7 29.8-222.3L1330.2 0H1304l-58 61.4c-57.3 60.6-137.6 59.7-178.5-2l-3.3-5A144 144 0 0 1 1043.1 0H0v1440h1920v-417.2l-153.7 162.7z'/%3e%3c/svg%3e");
    {% elseif mask_type == 'squares' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cpath d='M1730.8 1302.8l-343.3-343.3c-24.4-24.4-24.4-64 0-88.5l343.3-343.3c24.4-24.4 64-24.4 88.5 0L1920 628.5V228l-375 375c-48 48-126.2 48-174.4 0L953 185.2C905 137 905 59 953 11l11-11H0v1440h1920v-238l-100.7 100.7c-24.5 24.5-64 24.5-88.5 0m-644.5-232.3a86 86 0 0 1-121.3 0L706.3 811.8a86 86 0 0 1 0-121.3L965 432a86 86 0 0 1 121.3 0L1345 690.6a86 86 0 0 1 0 121.3l-258.7 258.6z'/%3e%3c/svg%3e");
    {% elseif mask_type == 'swirl' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cg%3e%3cpath d='M1382.5%2c970.7c-196.3-69.3-280.2-217.9-360.2-498C942.3%2c192.5%2c509.5%2c0%2c509.5%2c0H0v1440h1898.3 C1849.4%2c1340.2%2c1630%2c1058.1%2c1382.5%2c970.7'/%3e%3c/g%3e%3c/svg%3e");
    {% elseif mask_type == 'triangles' %}
      --mask: url("data:image/svg+xml,%3csvg fill='%23{{mask_color|replace({'\#': ''})}}' viewBox='0 0 1920 1440' preserveAspectRatio='xMinYMin slice' xmlns='http://www.w3.org/2000/svg' %3e%3cpath d='M559.2 0l980 887 381-371V0zm1021 924.3l339.7 307.4V602zM495.7 1440H1920v-112l-674.3-610.3z'/%3e%3c/svg%3e");
    
    ");
    {% endif %}
  }

  #{{uc_id}} .ue_background_mask {
    position: absolute;
    top: 0px;
    left: 0px;
    width: 100%;
    height: 100%;
    background-image: var(--mask);
    {% if mask_flip_horizontally == 'true' or mask_flip_vertically == 'true' %}
      transform: {% if mask_flip_vertically == 'true' %} rotateX(180deg) {% endif %} {% if mask_flip_horizontally == 'true' %} rotateY(180deg) {% endif %};
    {% endif %}
  }

{% endif %}

@media only screen and (max-width: {{pattern_mask_breakpoint}}px) {
  {% if pattern_hide_on_breakpoint == 'true' %}
  	#{{uc_id}} .ue_background_pattern {
      display: none;
    }
  {% endif %}
  {% if mask_hide_on_breakpoint == 'true' %}
  	#{{uc_id}} .ue_background_mask {
      display: none;
    }
  {% endif %}
}