#{{uc_id}}.ue-price-range-slider {
  display:flex;
  width:100%;
  direction: {{direction}};
}

#{{uc_id}} .ue-range-wrapper {
  width:100%;
}

#{{uc_id}} .noUi-handle, #{{uc_id}} .noUi-target {
  cursor:pointer;
}

{% if show_label == "true" %}
  #{{uc_id}} .ue-range-label{
    flex-shrink: 0;
    {% if label_position == "block" %}
      display: block;
      width: 100%;
    {% endif %}
  }
{% endif %}

#{{uc_id}} #{{uc_id}}_slider{
  width:100%;
}

{% if show_values_below_slider == "true" %}
  #{{uc_id}} .ue-range-values{
    display:flex;
    flex-direction:row;
    justify-content:space-between;
    width: 100%;
  }
{% endif %}

{% if show_range_input == "true" %}
  #{{uc_id}} .ue-range-num-input-wrapper{
    display:flex;
    flex-direction:row;
    justify-content:space-between;
    width: 100%;
  }

  #{{uc_id}} .ue-range-num-input{
    text-align:center;
  }

  #{{uc_id}} .ue-num-input-wrapper{
    display: flex;
    align-items: center;
    align-content: center;
    flex-direction: row;
    overflow:hidden;
  }

  {% if (show_prefix == "true") or (show_suffix == "true") %}
    #{{uc_id}} .ue-num-prefix, #{{uc_id}} .ue-num-suffix{
      display: flex;
      height: 100%;
      align-items: center;
      flex-direction: row;
    }
  {% endif %}
{% endif %}

{% if show_tooltip_values == "true" %}
  #{{uc_id}} .noUi-tooltip {
      display: block;
      position: absolute;
      text-align: center;
      white-space: nowrap;
  }

  #{{uc_id}} .noUi-horizontal .noUi-tooltip {
      -webkit-transform: translate(-50%, 0);
      transform: translate(-50%, 0);
      left: 50%;
  }

  #{{uc_id}} .noUi-vertical .noUi-tooltip {
      -webkit-transform: translate(0, -50%);
      transform: translate(0, -50%);
      top: 50%;
      right: 120%;
  }

  #{{uc_id}} .noUi-horizontal .noUi-origin > .noUi-tooltip {
      -webkit-transform: translate(50%, 0);
      transform: translate(50%, 0);
      left: auto;
  }

  #{{uc_id}} .noUi-vertical .noUi-origin > .noUi-tooltip {
      -webkit-transform: translate(0, -18px);
      transform: translate(0, -18px);
      top: auto;
      right: 28px;
  }
{% endif %}

#{{uc_id}} .noUi-tooltip{
   display: flex;
   flex-direction: row;
   align-items: center;
   justify-content: center;
   width: max-content;
}

#{{uc_id}} .noUi-connect.noUi-draggable {
  cursor: ew-resize;
}

#{{uc_id}} .ue-price-range-slider-reset{
  cursor: pointer;
  display: flex;
  align-items: center;
  transition: all .3s ease-out;
}

{% if hide_def_arrows == "true" %}
  /* Chrome, Safari, Edge, Opera */
  #{{uc_id}} input::-webkit-outer-spin-button,
  #{{uc_id}} input::-webkit-inner-spin-button {
    -webkit-appearance: none;
    margin: 0;
  }

  /* Firefox */
  #{{uc_id}} input[type=number] {
    -moz-appearance: textfield;
  }
{% endif %}


{% if show_grow_effect_on_hover == "true" %}
  #{{uc_id}} .noUi-touch-area:hover{
    box-shadow: 0 0 0 3px #fff, 0 0 0 6px {{thumb_color_hover}};
  }

  #{{uc_id}} .noUi-touch-area:hover {
    box-shadow: 0 0 0 3px #fff, 0 0 0 6px {{thumb_color_hover}};
  }
{% endif %}