#{{uc_id}}{
	position: relative;
}

#{{uc_id}} .ue-nav-menu-mobile-wrapper{
 	display: flex;
}

#{{uc_id}} .ue-menu{
    display:flex;
    list-style:none;
    margin:0;
    padding:0;
    position:relative;
  	justify-content:{{align}};
}

#{{uc_id}} a{
  	position: relative;
	text-decoration: none;
 	display: flex;
  	align-items: center;  
}

{% if styles == "no-hover-effects" %}
  #{{uc_id}} a:after,
  #{{uc_id}} a:before{
      content: "";
      z-index: 2;
      position:absolute;
  }
{% endif %}

{% if pointer == "underline" %}
    #{{uc_id}} a:hover:after,
	#{{uc_id}} a.uc-active:after{
        bottom: 0;
        height: 3px;
        width: 100%;
        left: 0;
        background-color: {{pointer_color}};
    }  
{% endif %}	

{% if pointer == "overline" %}
  	#{{uc_id}} a:hover:before,
	#{{uc_id}} a.uc-active:before{
      top: 0;
      height: 3px;
      width: 100%;
      left: 0;
      background-color: {{pointer_color}};
  	}
{% endif %}


{% if pointer == "double" %}
  	#{{uc_id}} a:hover:after,
	#{{uc_id}} a.uc-active:after{
      bottom: 0;
      height: 3px;
      width: 100%;
      left: 0;
      background-color: {{pointer_color}};
    }  
  	#{{uc_id}} a:hover:before,
	#{{uc_id}} a.uc-active:before{
      top: 0;
      height: 3px;
      width: 100%;
      left: 0;
      background-color: {{pointer_color}};
  	}
{% endif %}


{% if pointer == "framed" %}
  	#{{uc_id}} a:hover:before,
	#{{uc_id}} a.uc-active:before{
      top: 0;
      bottom:0;
      left:0;
      right:0;
      height: 100%;
      width: 100%;
      border-style:solid;
      border-width:3px;
      border-color:{{pointer_color}};
  	}
{% endif %}



#{{uc_id}} .sub-menu a{
	justify-content: space-between;
}

#{{uc_id}} .ue-menu > li {
	display: block;
  	{% if align == "stretch" %}
  		flex-grow: 1;
  	{% endif %}
}

/* Simple multilevel dropdown */
#{{uc_id}} .ue-menu > li > .sub-menu {
	opacity: 0;
	visibility: hidden;
	position: absolute;
	list-style: none;
	text-align: inherit;
	padding: 0px;
    display:block;
	z-index: 99;
}

/* First level appear */
#{{uc_id}} .ue-menu > li:hover > .sub-menu {
	opacity: 1;
	visibility: visible;
}

#{{uc_id}} .ue-menu > li.uc-active > .sub-menu {
	opacity: 1;
	visibility: visible;
}

/* Style for dropdown links */
#{{uc_id}} .ue-menu li > .sub-menu li {
	position: relative;
	display: block;
}

/* Second and third dropdown level */
#{{uc_id}} .ue-menu > li > .sub-menu li{
  display: block;
}

#{{uc_id}} .ue-menu > li > .sub-menu > li .sub-menu {
	opacity: 0;
	visibility: hidden;
	position: absolute;
	list-style: none;
	top:0px;
	padding: 0px;
  	z-index: 100;
}

/* Second and third level appears */
#{{uc_id}} .ue-menu > li .sub-menu li:hover > .sub-menu {
	opacity: 1;
	visibility: visible;
}

#{{uc_id}} .ue-menu > li .sub-menu li.uc-active > .sub-menu {
	opacity: 1;
	visibility: visible;
}

#{{uc_id}} li,
#{{uc_id}} a{
	transition: all 0.3s ease-in-out;
}

#{{uc_id}} ul{
	transition: opacity 0.3s ease-in-out;
}

#{{uc_id}} .ue-nav-menu-checkbox{ 
  	display: none; 
}

#{{uc_id}} .ue-nav-menu-mobile{
  	display: none;
	transition: all .3s;
}

#{{uc_id}} .ue-nav-menu-icon{
	display: flex;
}

#{{uc_id}} .ue-nav-menu-mobile > *{
	display: none;
  	justify-content: center;
  	align-items: center;
}
#{{uc_id}} .ue-nav-menu-mobile > .uc-active{
	display: flex;
}

/* hover effects */
{% if (styles == "uc_cl-effect-1") %}
/*Effect 1*/
#{{uc_id}} .uc_cl-effect-1 a:hover::before, 
#{{uc_id}} .uc_cl-effect-1 a:hover::after, 
#{{uc_id}} .uc_cl-effect-1 a:focus::before, 
#{{uc_id}} .uc_cl-effect-1 a:focus::after, 
#{{uc_id}} .uc_cl-effect-1 a.active::before, 
#{{uc_id}} .uc_cl-effect-1 a.active::after{
  color: {{hover_border_color}};
}
{% endif %}

{% if (styles == "uc_cl-effect-3") %}
/*Effect 3*/
#{{uc_id}} .uc_cl-effect-3 a::after {
    background: {{hover_border_color}};
}
{% endif %}

{% if (styles == "uc_cl-effect-4") %}
/*Effect 4*/
#{{uc_id}} .uc_cl-effect-4 a::after {
    background: {{hover_border_color}};
}
{% endif %}


{% if (styles == "uc_cl-effect-5") %}
/*Effect 4*/
#{{uc_id}} .uc_cl-effect-5 a {
    height:auto;
}
{% endif %}

{% if (styles == "uc_cl-effect-6") %}
/*Effect 6*/
#{{uc_id}} .uc_cl-effect-6 a::before,
#{{uc_id}} .uc_cl-effect-6 a::after {
    background: {{border_color}};
}
#{{uc_id}} .uc_cl-effect-6 a:hover::before,
#{{uc_id}} .uc_cl-effect-6 a:hover::after {
    background: {{hover_border_color}};
}
{% endif %}

{% if (styles == "uc_cl-effect-7") %}
/*Effect 7*/
#{{uc_id}} .uc_cl-effect-7 a::before, 
#{{uc_id}} .uc_cl-effect-7 a::after {
    background: {{border_color}};
}
#{{uc_id}} .uc_cl-effect-7 a:hover::before, 
#{{uc_id}} .uc_cl-effect-7 a:hover::after {
    background: {{hover_border_color}};
}
{% endif %}

{% if (styles == "uc_cl-effect-8") %}
/*Effect 8*/
#{{uc_id}} .uc_cl-effect-8 a::before, 
#{{uc_id}} .uc_cl-effect-8 a::after {
    border: 3px solid {{border_color}};
}
#{{uc_id}} .uc_cl-effect-8 a::after {
    border-color: {{hover_border_color}};
}
{% endif %}

{% if (styles == "uc_cl-effect-11") %}
/*Effect 11*/
#{{uc_id}} .uc_cl-effect-11 a {
    border-top: 2px solid {{border_color}};
    color: {{text_color}};
}
#{{uc_id}} .uc_cl-effect-11 a::before {
    border-bottom: 2px solid {{hover_border_color}};
    color: {{hover_text_color}};
}
{% endif %}

{% if (styles == "uc_cl-effect-12") %}
/*Effect 12*/
#{{uc_id}} .uc_cl-effect-12 a::before, 
#{{uc_id}} .uc_cl-effect-12 a::after {
    border: 2px solid {{hover_border_color}};
}
{% endif %}

{% if (styles == "uc_cl-effect-13") %}
/*Effect 13*/
#{{uc_id}} .uc_cl-effect-13 a:hover, 
#{{uc_id}} .uc_cl-effect-13 a:focus,
#{{uc_id}} .uc_cl-effect-13 a.active{
    color: {{hover_text_color}};
}
#{{uc_id}} .uc_cl-effect-13 a:hover::before, 
#{{uc_id}} .uc_cl-effect-13 a:focus::before{
    color: {{hover_border_color}};
}
#{{uc_id}} .uc_cl-effect-13 a:hover::before, 
#{{uc_id}} .uc_cl-effect-13 a:focus::before,
#{{uc_id}} .uc_cl-effect-13 a.active::before{
	text-shadow: 10px 0 {{hover_border_color}}, -10px 0 {{hover_border_color}};
	-webkit-text-shadow: 10px 0 {{hover_border_color}}, -10px 0 {{hover_border_color}};
}
{% endif %}

{% if (styles == "uc_cl-effect-14") %}
/*Effect 14*/
#{{uc_id}} .uc_cl-effect-14 a::before, 
#{{uc_id}} .uc_cl-effect-14 a::after {
    background: {{border_color}};
}
#{{uc_id}} .uc_cl-effect-14 a:hover::before, 
#{{uc_id}} .uc_cl-effect-14 a:hover::after {
    background: {{hover_border_color}};
}
{% endif %}

{% if (styles == "uc_cl-effect-15") %}
/*Effect 15*/
#{{uc_id}} .uc_cl-effect-15 a {
    color: {{text_color}};
}
#{{uc_id}} .uc_cl-effect-15 a::before {
    color: {{hover_text_color}};
}
{% endif %}

{% if (styles == "uc_cl-effect-16") %}
/*Effect 16*/
#{{uc_id}} .uc_cl-effect-16 a {
    color: {{text_color}};
}
#{{uc_id}} .uc_cl-effect-16 a::before {
    color: {{hover_text_color}};
}
{% endif %}

{% if (styles == "uc_cl-effect-17") %}
/*Effect 17*/
#{{uc_id}} .uc_cl-effect-17 a {
    color: {{hover_text_color}};
}
#{{uc_id}} .uc_cl-effect-17 a::before {
    color: {{text_color}};
}
#{{uc_id}} .uc_cl-effect-17 a::after {
    background: {{hover_border_color}};
}
{% endif %}

{% if (styles == "uc_cl-effect-18") %}
/*Effect 18*/
#{{uc_id}} .uc_cl-effect-18 a::before, 
#{{uc_id}} .uc_cl-effect-18 a::after {
    background: {{border_color}};
}
#{{uc_id}} .uc_cl-effect-18 a:hover::before, 
#{{uc_id}} .uc_cl-effect-18 a:hover::after {
    background: {{hover_border_color}};
}
{% endif %}

{% if (styles == "uc_cl-effect-21") %}
/*Effect 21*/
#{{uc_id}} .uc_cl-effect-21 a {
    color: {{text_color}};
}
#{{uc_id}} .uc_cl-effect-21 a::before, 
#{{uc_id}} .uc_cl-effect-21 a::after{
    background: {{hover_border_color}};
}
#{{uc_id}} .uc_cl-effect-21 a:hover, 
#{{uc_id}} .uc_cl-effect-21 a:focus,
#{{uc_id}} .uc_cl-effect-21 a.active{
    color: {{hover_text_color}};
}
{% endif %}
/* end hover effects */

@media only screen and (max-width: 1024px) {
    
      #{{uc_id}} .ue-menu{
          justify-content:{{align_tablet}};
      }
      {% if align_tablet == "stretch" %}
        #{{uc_id}} .ue-menu > li { 
            flex-grow: 1;  	
        }
      {% endif %}
}

@media only screen and (max-width: 767px) {
    
  	 #{{uc_id}} .ue-menu{
          justify-content:{{align_mobile}};
     }
     {% if align_mobile == "stretch" %}
       #{{uc_id}} .ue-menu > li {  	
            flex-grow: 1;  	
       }
     {% endif %}
}


@media only screen and (max-width: {{responsive_breakpoint}}px) {
  
	#{{uc_id}} .ue-menu {
     	opacity: 0;
      	transform: translate(0, -20px);
      	pointer-events: none;
      	transition: all .3s;
      	flex-direction: column;
      	position: absolute;
      	width: 100%;
      	top: 100%;
      	left: 0;
      	z-index: 1000;
    }
  
    #{{uc_id}} .sub-menu{
      	visibility: visible !important;
      	opacity: 1 !important;
      	inset-inline-start: unset !important;
        transition-timing-function: ease;
    } 	

	#{{uc_id}} .ue-nav-menu-mobile {
        position: relative;
        display: flex;
        align-items:center;
        justify-content:center;      
	}

	#{{uc_id}} .ue-nav-menu-checkbox:checked + .ue-menu {
		opacity: 1;
      	transform: translate(0, {{responsive_menu_spacing}}px);
      	pointer-events: all;
	}

	#{{uc_id}} .ue-menu > li > .sub-menu {
		width: 100%;
        position:relative;
        top:auto;
	}

	#{{uc_id}} .ue-menu > li > .sub-menu > li .sub-menu {
		width: 100%;
		left: 0;
		z-index: 2;
        position:relative;
        top:auto;
	}

	#{{uc_id}} .ue-menu > li > ul li ul li ul {
		width: 100%;
      	position:relative;
	}
  
}