#{{uc_id}}
{
  display:grid;
  grid-auto-rows: 1fr;
}

.ue-btn
{
  text-decoration:none;
  text-align:center;
  transition:0.3s;
}

#{{uc_id}} .ue-overlay-link
{
  display:block;
  position:absolute;
  top:0px;
  bottom:0px;
  right:0px;
  left:0px;
}

#{{uc_id}} .ue-item
{
  position:relative;
  display:flex;
  overflow:hidden;
  background-size:cover;
}

#{{uc_id}} .ue-item-overlay
{
  position:absolute;
  top:0;
  right:0;
  left:0;
  bottom:0;
  transition:0.3s;
}

#{{uc_id}} .ue-item-bg
{
  position:absolute;
  top:0;
  right:0;
  left:0;
  bottom:0;
  transition:{{background_hover_grow_speed}}s;
  background-size:cover;
}


{% if background_hover_grow == "true" %}
	#{{uc_id}} .ue-item:hover .ue-item-bg
      {
        transform:scale(1.1);
      }
{% endif %}	






#{{uc_id}} .ue-graphic-element
{
  display:inline-flex;
  align-items:center;
  justify-content:center;
  line-height:1em;
  overflow:hidden;
}

#{{uc_id}} .ue-graphic-element svg
{
  height:1em;
  width:1em;
}

#{{uc_id}} .ue-graphic-element img
{
  display:block;
}

{% if show_title_on_hover == "true" %}
  #{{uc_id}} .ue-item-title
  {
    opacity: 0;
    transition: all .3s;
  }
  #{{uc_id}} .ue-item:hover .ue-item-title
  {
    opacity: 1;
  }
{% endif %}	

.ue-item-title
{
  font-size:21px;
}

#{{uc_id}} .ue-item-content
{
  position:relative;
  width:100%;
}



{% if breakpoint == "true" %}
	@media only screen and (max-width: {{breakpoint_width}}px) {
      
      
      #{{uc_id}}  {
          grid-template-columns: repeat(1, 1fr);
        }
      
      #{{uc_id}} .ue-item
      {
        grid-column: span 1;
        grid-row: span 1;
      }
      
      
      }
{% endif %}	


{% if entrance_animation == "scale-in-center" %}

#{{uc_id}} .ue-item:hover .scale-in-center {
	-webkit-animation: scale-in-center 0.5s cubic-bezier(0.250, 0.460, 0.450, 0.940) both;
	        animation: scale-in-center 0.5s cubic-bezier(0.250, 0.460, 0.450, 0.940) both;
}

#{{uc_id}} .ue-item-content
{
  -webkit-transform: scale(0);
            transform: scale(0);
    opacity: 1;
}

@-webkit-keyframes scale-in-center {
  0% {
    -webkit-transform: scale(0);
            transform: scale(0);
    opacity: 1;
  }
  100% {
    -webkit-transform: scale(1);
            transform: scale(1);
    opacity: 1;
  }
}
@keyframes scale-in-center {
  0% {
    -webkit-transform: scale(0);
            transform: scale(0);
    opacity: 1;
  }
  100% {
    -webkit-transform: scale(1);
            transform: scale(1);
    opacity: 1;
  }
}
{% endif %}


{% if entrance_animation == "rotate-in-center" %}
#{{uc_id}} .ue-item:hover .rotate-in-center {
	-webkit-animation: rotate-in-center 0.6s cubic-bezier(0.250, 0.460, 0.450, 0.940) both;
	        animation: rotate-in-center 0.6s cubic-bezier(0.250, 0.460, 0.450, 0.940) both;
}

#{{uc_id}} .ue-item-content
{
  -webkit-transform: rotate(-360deg);
            transform: rotate(-360deg);
    opacity: 0;
}

@-webkit-keyframes rotate-in-center {
  0% {
    -webkit-transform: rotate(-360deg);
            transform: rotate(-360deg);
    opacity: 0;
  }
  100% {
    -webkit-transform: rotate(0);
            transform: rotate(0);
    opacity: 1;
  }
}
@keyframes rotate-in-center {
  0% {
    -webkit-transform: rotate(-360deg);
            transform: rotate(-360deg);
    opacity: 0;
  }
  100% {
    -webkit-transform: rotate(0);
            transform: rotate(0);
    opacity: 1;
  }
}
{% endif %}






{% if entrance_animation == "puff-in-center" %}
#{{uc_id}} .ue-item:hover .puff-in-center {
	-webkit-animation: puff-in-center 0.7s cubic-bezier(0.470, 0.000, 0.745, 0.715) both;
	        animation: puff-in-center 0.7s cubic-bezier(0.470, 0.000, 0.745, 0.715) both;
}

#{{uc_id}} .ue-item-content
{

    opacity: 0;
}

@-webkit-keyframes puff-in-center {
  0% {
    -webkit-transform: scale(2);
            transform: scale(2);
    -webkit-filter: blur(4px);
            filter: blur(4px);
    opacity: 0;
  }
  100% {
    -webkit-transform: scale(1);
            transform: scale(1);
    -webkit-filter: blur(0px);
            filter: blur(0px);
    opacity: 1;
  }
}
@keyframes puff-in-center {
  0% {
    -webkit-transform: scale(2);
            transform: scale(2);
    -webkit-filter: blur(4px);
            filter: blur(4px);
    opacity: 0;
  }
  100% {
    -webkit-transform: scale(1);
            transform: scale(1);
    -webkit-filter: blur(0px);
            filter: blur(0px);
    opacity: 1;
  }
}

{% endif %}







{% if entrance_animation == "bounce-in-top" %}
#{{uc_id}} .ue-item:hover .bounce-in-top {
	-webkit-animation: bounce-in-top 1.1s both;
	        animation: bounce-in-top 1.1s both;
}

#{{uc_id}} .ue-item-content
{
	 -webkit-transform: translateY(-500px);
            transform: translateY(-500px);
    opacity: 0;
}

@-webkit-keyframes bounce-in-top {
  0% {
    -webkit-transform: translateY(-500px);
            transform: translateY(-500px);
    -webkit-animation-timing-function: ease-in;
            animation-timing-function: ease-in;
    opacity: 0;
  }
  38% {
    -webkit-transform: translateY(0);
            transform: translateY(0);
    -webkit-animation-timing-function: ease-out;
            animation-timing-function: ease-out;
    opacity: 1;
  }
  55% {
    -webkit-transform: translateY(-65px);
            transform: translateY(-65px);
    -webkit-animation-timing-function: ease-in;
            animation-timing-function: ease-in;
    opacity: 1;
  }
  72% {
    -webkit-transform: translateY(0);
            transform: translateY(0);
    -webkit-animation-timing-function: ease-out;
            animation-timing-function: ease-out;
    opacity: 1;
  }
  81% {
    -webkit-transform: translateY(-28px);
            transform: translateY(-28px);
    -webkit-animation-timing-function: ease-in;
            animation-timing-function: ease-in;
    opacity: 1;
  }
  90% {
    -webkit-transform: translateY(0);
            transform: translateY(0);
    -webkit-animation-timing-function: ease-out;
            animation-timing-function: ease-out;
    opacity: 1;
  }
  95% {
    -webkit-transform: translateY(-8px);
            transform: translateY(-8px);
    -webkit-animation-timing-function: ease-in;
            animation-timing-function: ease-in;
    opacity: 1;
  }
  100% {
    -webkit-transform: translateY(0);
            transform: translateY(0);
    -webkit-animation-timing-function: ease-out;
            animation-timing-function: ease-out;
    opacity: 1;
  }
}
@keyframes bounce-in-top {
  0% {
    -webkit-transform: translateY(-500px);
            transform: translateY(-500px);
    -webkit-animation-timing-function: ease-in;
            animation-timing-function: ease-in;
    opacity: 0;
  }
  38% {
    -webkit-transform: translateY(0);
            transform: translateY(0);
    -webkit-animation-timing-function: ease-out;
            animation-timing-function: ease-out;
    opacity: 1;
  }
  55% {
    -webkit-transform: translateY(-65px);
            transform: translateY(-65px);
    -webkit-animation-timing-function: ease-in;
            animation-timing-function: ease-in;
    opacity: 1;
  }
  72% {
    -webkit-transform: translateY(0);
            transform: translateY(0);
    -webkit-animation-timing-function: ease-out;
            animation-timing-function: ease-out;
    opacity: 1;
  }
  81% {
    -webkit-transform: translateY(-28px);
            transform: translateY(-28px);
    -webkit-animation-timing-function: ease-in;
            animation-timing-function: ease-in;
    opacity: 1;
  }
  90% {
    -webkit-transform: translateY(0);
            transform: translateY(0);
    -webkit-animation-timing-function: ease-out;
            animation-timing-function: ease-out;
    opacity: 1;
  }
  95% {
    -webkit-transform: translateY(-8px);
            transform: translateY(-8px);
    -webkit-animation-timing-function: ease-in;
            animation-timing-function: ease-in;
    opacity: 1;
  }
  100% {
    -webkit-transform: translateY(0);
            transform: translateY(0);
    -webkit-animation-timing-function: ease-out;
            animation-timing-function: ease-out;
    opacity: 1;
  }
}

{% endif %}