{% if( taxonomy is empty and uc_inside_editor == "yes" ) %}
	<div class="uc-empty-message">
		{{no_terms_found|raw}}
	</div> 
{% endif %}

<div id="{{uc_id}}" class="uc-select-filter {{filter_addclass}}" data-filtertype="select" {{filter_attributes|raw}} style="{{filter_style|raw}}" >

  {% if show_label == "true" %}
  <label for="select-{{uc_id}}">{{label_text|raw}}</label> 
  {% endif %}

  <div class="uc-select-filter__select-wrapper">
    <select class="uc-select-filter__select select-{{uc_id}}">

      {% for term in taxonomy %}

      {% if(term.hidden is empty) %}

      <option value="{{term.id}}" class="uc-select-filter__option {{filter_addclass_item}} {{term.addclass}}" {{term.html_data|raw}} {{term.html_attributes|raw}}>

          <span  class="uc-select-filter__name">{{term.name|raw}}</span>
          {% if show_number_of_posts == "true" %}
             <span class="uc-select-filter__spacer"></span>
             <span class="uc-select-filter__numposts">{{term.num_posts}}</span>
          {% endif %}

      </option>  

      {% endif %}

      {% endfor %}

    </select>
    <div class="uc-select-filter__select-indicator">{{indicator_icon_html|raw}}</div>
  </div>  

  {# ----- output empty items -------- #}
  
  {% for term in taxonomy %}
 
    {% if(term.hidden is not empty) %}

    	<span value="{{term.id}}" class="uc-select-filter__option {{filter_addclass_item}} {{term.addclass}}" data-id="{{term.id}}" data-slug="{{term.slug}}" data-taxonomy="{{term.taxonomy}}" {{term.html_attributes|raw}}></span>  
  
  	{% endif %}
  
  {% endfor %}
  
 
<div class="uc-select-filter__loader" style="display:none"></div>

</div>