#{{uc_id}} * {
	-webkit-box-sizing: border-box;
	-moz-box-sizing: border-box;
	box-sizing: border-box;
    
}

#{{uc_id}} .ue_woocommerce_product_label-custom-field{
	z-index: 100;
}

#{{uc_id}} .uc_post_grid_style_one_item{
	transition: all.3s;
}

#{{uc_id}} span.add-to-cart__loader{
  	position: absolute;
  	right: 0;
  	top: 50%;
  	transform: translate(0, -50%);
  	line-height: 1em;
}
#{{uc_id}} .add_to_cart_button.loading span.add-to-cart__loader{
	display: inline-block !important;
}

#{{uc_id}} .uc-grid-count-buttons{
	display: flex;
}

#{{uc_id}} .uc-grid-count-buttons button{
	display: flex;
    align-items:center;
    justify-content:center;
    flex-grow:0;
    flex-shrink:0;
    line-height:1em;
}

#{{uc_id}} .uc-grid-count-buttons button:disabled{
	opacity:0.5;
}

#{{uc_id}} .uc-grid-count-buttons button svg{
	height:1em;
    width:1em;
}

#{{uc_id}} input.uc-grid-count-buttons__number{
  text-align:center;
  flex-grow:1;
}


#{{uc_id}} 
{
  margin:0 auto;
  position:relative;  
}

.uc_post_grid_style_one .uc_post_grid_style_one_item {
	color: #111;
	font-size: 16px;
	overflow: hidden;
  	position: relative;
}
#{{uc_id}} .uc_post_grid_style_one_image {
	width: 100%;
	overflow: hidden;
	display: block;
  	position: relative;
}
#{{uc_id}} .uc_post_image {
    position:relative;
	display: block;
	transition: all 0.25s ease-in-out;
    overflow:hidden;
}

#{{uc_id}} .uc_post_image--second{
  	width: 100%;
    height: 100%;
    object-fit: cover;
	position: absolute;
  	top: 0;
  	right: 0;
  	{% if swap_animation_type == "slide" %}
  		{% if swap_slide_direction == "left" %}
  			transform: translate(-100%, 0);
  		{% elseif swap_slide_direction == "right" %}
  			transform: translate(100%, 0);
  		{% elseif swap_slide_direction == "top" %}
    		transform: translate(0, -100%);
  		{% elseif swap_slide_direction == "bottom" %}
  			transform: translate(0, 100%);
  		{% endif %}    
  	{% elseif swap_animation_type == "fade" %}
  		opacity: 0;
  	{% endif %} 
  	transition: all .3s;
}

#{{uc_id}} .uc_post_grid_style_one_image:hover .uc_post_image--second{  
  	{% if swap_animation_type == "slide" %}
		transform: translate(0, 0);
  	{% elseif swap_animation_type == "fade" %}
  		opacity: 1;
  	{% endif %}
}

#{{uc_id}}  .uc_post_image img
{
  width:100%;
  display: block;
  transition:0.3s;
}

{% if image_grow_on_hover	 == "true" %}
#{{uc_id}} .ue-item:hover .uc_post_image img
{
  transform:scale(1.1);
}
{% endif %}



.uc_post_grid_style_one .uc_title {
    font-size: 21px;
}
.uc_post_grid_style_one .uc_title a {
	text-decoration: none;
}

{% if button_style == "block" %}
#{{uc_id}} .uc_post_grid_style_one_button > button{
	width: 100%;
}
{% endif %}

#{{uc_id}} .uc_post_grid_style_one_button > a,
#{{uc_id}} .uc_post_grid_style_one_button > button,
#{{uc_id}} .uc-button-addcart,
#{{uc_id}} .added_to_cart{
	display: {{button_style}};
	text-align: center;
    text-decoration: none;
    text-transform: none;
	transition: all 0.25s ease-in-out;
    vertical-align: middle;
}

{% if (show_add_to_cart_instead_of_view_cart_ == "false") %}
  #{{uc_id}} .uc-button-addcart.added{
    display:none;
  }
{% elseif (show_add_to_cart_instead_of_view_cart_ == "true") %}
  #{{uc_id}} .added_to_cart{
	display:none !important;
  }
{% endif %}

#{{uc_id}}.uc_post_grid_style_one .uc_post_grid_style_one_wrap {	
    display: grid;
}

{% if (layout == "under") %}
    #{{uc_id}}.uc_post_grid_style_one .uc_content{
      flex-grow: 1;
      display: flex;
      flex-flow: column nowrap;
    }
    #{{uc_id}} .ue_grid_item_bottom
    {
      margin-top:auto;
    }
.uc_post_grid_style_one .uc_post_grid_style_one_item {
	flex-direction:column;
    display:flex;
}
{% endif %}


{% if layout == "overlay" %}
	#{{uc_id}}.uc_post_grid_style_one .uc_content{
      position:absolute;
      top:0px;
      left:0px;
      bottom:0px;
      right:0px;
      opacity:0;
      transition:1s;
      display:flex;
      align-items:center;
      flex-direction:column;
      justify-content: center;
    }

	#{{uc_id}} .uc_post_grid_style_one_item:hover .uc_content{
      opacity:1;
    }

    #{{uc_id}} .uc_content-link{
	  display: block;
      position:absolute;
      z-index: 1;
      top:0px;
      left:0px;
      bottom:0px;
      right:0px;
    }

{% endif %}

{% if layout == "partial_overlay" %}
	#{{uc_id}}.uc_post_grid_style_one .uc_content{
     position:absolute;
     bottom:20px;
     left:20px;
     right:20px;
     
    }

{% endif %}

{% if layout == "under_overlap" %}
	#{{uc_id}}.uc_post_grid_style_one .uc_content{
     margin-left:20px;
      margin-right:20px;
      margin-top:-30px;
      position:relative;
      flex-grow: 1;
      display: flex;
      flex-flow: column nowrap;
    }
    #{{uc_id}} .ue_grid_item_bottom
    {
      margin-top:auto;
    }
.uc_post_grid_style_one .uc_post_grid_style_one_item {
	flex-direction:column;
    display:flex;
}
{% endif %}

{% if layout == "reveal_from_bottom" %}
	#{{uc_id}}.uc_post_grid_style_one .uc_content{
        margin-left:0px;
        margin-right:0px;
        margin-top:0px;
        position:absolute;
      	bottom: -100%;
        left: 0;
        right: 0;
        transition: ease-in-out all 0.25s;
      	-webkit-transition: ease-in-out all 0.25s;
    }
    #{{uc_id}}.uc_post_grid_style_one .uc_post_grid_style_one_item:hover .uc_content{
		bottom: 0;
    }
{% endif %}

@media (max-width:1023px){
	#{{uc_id}}.uc_post_grid_style_one .uc_post_grid_style_one_wrap {
		grid-template-columns: repeat({{items_in_column_tablet}}, 1fr);
	}
}
@media (max-width:639px){
	#{{uc_id}}.uc_post_grid_style_one .uc_post_grid_style_one_wrap {
		grid-template-columns: repeat({{items_in_column_mobile}}, 1fr);
	}
}


{% if layout == "side_by_side" %}
	#{{uc_id}} .uc_post_grid_style_one_item {
     display:flex;  
     flex-direction:row;
    }
    #{{uc_id}} .uc_post_grid_style_one_item > div{
     width:50%;
    }
   
    #{{uc_id}} .uc_content
    {
      display:flex;
      flex-direction:column;
      justify-content:center;
    }
 
{% endif %}


#{{uc_id}} .ue_category_label
{
  display:block;
  text-decoration:none;
}

/* hide default arrows in input type number */
/* Chrome, Safari, Edge, Opera */
#{{uc_id}} input.uc-grid-count-buttons__number::-webkit-outer-spin-button,
#{{uc_id}} input.uc-grid-count-buttons__number::-webkit-inner-spin-button{
	-webkit-appearance: none;
  	margin: 0;
}

/* Firefox */
#{{uc_id}} input.uc-grid-count-buttons__number[type=number]{
	-moz-appearance: textfield;
}
/* end hide default arrows in input type number */

.uc_regular_price
{
  text-decoration:line-through !important;
}

del{
  display: block;
  color: #000;
  opacity: .5;
  font-size: 26px;
  font-weight: 400;
  text-decoration:line-through !important;
}

ins{
  color: #000;
  font-size: 36px;
  font-weight: 400;
  text-decoration: none;
}

#{{uc_id}} .ue_woocommerce_product_carousel_sale_label
{
  display:inline-block;
  position:absolute;
  z-index: 1;
  {{horizontal_snap}}:{{label_horizontal_distance}}px;
  {{vertical_snap}}:{{label_vertical_distance}}px;
}

#{{uc_id}} .ue_woocommerce_product_grid_out_of_stock_label{
  	{% if (show_image == "true") %}
    position: absolute;
  	{% endif %}
  	width: fit-content;
  	{{horizontal_snap}}:{{label_horizontal_distance}}px;
  	{{vertical_snap}}:{{label_vertical_distance}}px;
  	z-index: 1;
}

#{{uc_id}} .ue-inner-btn-wrapper
{
  display:flex;
  align-items:center;
  justify-content:center;
  position: relative;
  pointer-events: none;
}