#{{uc_id}} nav
{
  padding:0px;
  margin:0px;
}

#{{uc_id}} 
{
  display:flex;
  flex-wrap: wrap;
  justify-content:{{alignment}};
}

#{{uc_id}} .nav-links
{
  display:flex;
  justify-content:{{alignment}};
}

#{{uc_id}} .nav-links > *
{
}

#{{uc_id}} .page-numbers
{
  display:flex;
  
  align-items:center;
  justify-content:center;
  transition:0.3s;
  line-height:1em;
}


#{{uc_id}} a.page-numbers, #{{uc_id}} .dots
{
  color:{{page_numbers_color}};
  background-color:{{page_numbers_background}};
}

#{{uc_id}} a.page-numbers:hover
{
  color:{{page_numbers_text_hover}};
  background-color:{{page_numbers_background_hover}};
}

#{{uc_id}} .page-numbers.current,
#{{uc_id}} .page-numbers.current:hover
{
  background-color:{{current_page_background}};
  color:{{current_page_text_color}};
}


#{{uc_id}} .page-numbers.prev, #{{uc_id}} .page-numbers.next
{
  padding-left:15px;
  padding-right:15px;
}


{% if show_icons == "true" %}

#{{uc_id}} .prev:before {
   font-family: "Font Awesome 5 Free";
   content: "\{{prev_icon|raw}}";
   display: inline-block;
   vertical-align: middle;
   font-weight: 900;
   {% if show_text == "true" %}padding-right:10px;{% endif %}
}

#{{uc_id}} .next:after {
   font-family: "Font Awesome 5 Free";
   content: "\{{next_icon|raw}}";
   display: inline-block;
   vertical-align: middle;
   font-weight: 900;
   {% if show_text == "true" %}padding-left:10px;{% endif %}
}
{% endif %}

#{{uc_id}}.uc-ajax-loading{
	opacity:1 !important;
}

#{{uc_id}}.uc-ajax-loading .current{
	position:relative;
    overflow:hidden;
}

{% if loader == "true" %}

#{{uc_id}}.uc-ajax-loading .current:before{
  content: "";
  display:block;
  width:100%;
  height:100%;
  box-sizing:border-box;
  position:absolute;
  top:0px;
  left:0px;
  background-color: {{loader_color}};
  animation: uc-spinning-border 0.5s linear infinite;
  opacity:50%;
  border-radius:inherit;
}

@keyframes uc-spinning-border {
	0%{transform: scale(0);}
	100%{transform: scale(1); }	
}

{% endif %}