{% if disable_page_scroll == "true" %}
html.uc-menu-open,
body.uc-menu-open{
  overflow: hidden;
}
{% endif %}

#{{uc_id}}{
  position: relative;
}

#{{uc_id}} *{
  box-sizing:border-box;
}

#{{uc_id}} .uc-mega_menu_list{
  display: flex;
  list-style: none;
  padding:0px;
  margin: 0;
}

#{{uc_id}} .uc-mega_menu_section{
  position: absolute;
  z-index: 99997;
  top: 100%;
  left: 50%;
  transform: translate(-50%, 0);
  padding-top: {{offset_y}}px;
  pointer-events: none;
  overflow: hidden;
  visibility: hidden;
}

#{{uc_id}} .uc-mega_menu_section-cover{
  position: absolute;
  z-index: 99996;
  pointer-events: none;
  {% if (show_tip == "true") and (offset_y < 14) %}
  top: calc(100% + 14px);
  {% else %}
  top: calc(100% + {{offset_y}}px);
  {% endif %}
  opacity: 0;
  pointer-events: none;
  transition: opacity {{open_transition_speed}}ms;
}

#{{uc_id}} .uc-mega_menu-wrapper  {
    left: 0;
    top: 0;
    height: 100%;
    position: relative;
    z-index: 99996;
    overflow-y: visible;
}

{% if (position_x == "item_left") %}
    #{{uc_id}} .uc-mega_menu_section{
      left: 0;
      transform: translate({{offset_x}}px, 0);
      padding-top: {{offset_y}}px;
    }
    #{{uc_id}} .uc-mega_menu_list_item{
        position: relative;
    }
{% elseif (position_x == "item_right") %}
    #{{uc_id}} .uc-mega_menu_section{
      left: unset;
      right: 0;
      transform: translate({{offset_x}}px, 0);
      padding-top: {{offset_y}}px;
    }
    #{{uc_id}} .uc-mega_menu_list_item{
        position: relative;
    }
{% elseif (position_x == "item_center") %}
  #{{uc_id}} .uc-mega_menu_section{
      left: 50%;
      transform: translate(calc(-50% + {{offset_x}}px), 0);
      padding-top: {{offset_y}}px;
    }
    #{{uc_id}} .uc-mega_menu_list_item{
        position: relative;
    }
{% endif %}

#{{uc_id}} .uc-mega_menu_section.section-error .uc-section-error{
  	text-align: center;
  	min-height: 400px;
  	padding: 15px;
  	display: flex;
  	justify-content: center;
  	align-items: center;
  	background-color: #cccccc;
  	position: relative;
  	z-index: 99997;
}

#{{uc_id}} .uc-mega_menu_title{
  	display: flex;
  	gap: 5px;
  	align-items: center;
  	{% if menu_item_open == "click" %}
	cursor: pointer;
  	{% endif %}	
    position:relative;
  	z-index: 99998;
}	

#{{uc_id}} .uc-mega_menu_list_item,
#{{uc_id}} .uc-active_item .uc-mega_menu_title{
  transition: all 0.3s;
  text-align: center;
}

#{{uc_id}} .uc-mega_menu_list{
	width: 100%;
}

#{{uc_id}} .uc-mega_menu_section.uc-active_item{
  pointer-events: all;
  z-index: 99998;
  visibility: visible;
}

#{{uc_id}} .uc-mega_menu_section.uc-active_item + .uc-mega_menu_section-cover{
	opacity: 1;
    pointer-events: all;
}

#{{uc_id}} .uc-error{
color: red;
font-weight: 700;
}

#{{uc_id}} .uc-message{
	text-align: center;
}

#{{uc_id}} .uc-mega_menu-wrapper.uc-menu-open{
  transform: translate(0, 0);
}

#{{uc_id}} .uc_mega_menu_overlay{
  cursor: default;
  display: none;
  position: absolute;
  top: calc(100% + {{offset_y}}px);
  left: 0;
  transition: opacity 0.3s;
  z-index: 99995;
  opacity: 0;
}

#{{uc_id}} .uc_mega_menu_overlay-inner{
	height: 100%;
}

#{{uc_id}}.uc-menu-open .uc_mega_menu_overlay{
  	opacity: 1;
}

#{{uc_id}} .uc-mega_menu_list_item.section-error .uc-mega_menu_title{
	border: 2px solid red;
  	position: relative;
}

#{{uc_id}} .uc-mega_menu_list_item.section-error .uc-mega_menu_title::before{
	content: "";
	position: absolute;
  	width: 4px;
  	height: 4px;
  	border-radius: 50%;
  	background-color: red;
  	top: 8px;
  	right: 8px;
  	z-index: 2;
}

#{{uc_id}} .uc-mega_menu_list_item.section-error .item-error{
	position: absolute;
  	left: 50%;
  	top: 0;
  	transform: translate(-50%, -100%);
  	z-index: 2;
  	width: max-content;
  	color: red;
  	opacity: 0;
  	transition: all .3s;
}

#{{uc_id}} .uc-mega_menu_list_item.section-error .uc-mega_menu_title:hover .item-error{
	opacity: 1;
}

#{{uc_id}} .available_id_s{
	padding: 15px;
  	background-color: #ffffff;
  	color: #000000;
}

#{{uc_id}} .uc_expand_indicator::before{
	font-family: "Font Awesome 5 Free";
    content: "\{{collapsed_font_awesome}}";
    font-weight: 900;
    line-height:1em;
  	display: inline-flex;
}

#{{uc_id}} .uc_collapse_indicator::before{
	font-family: "Font Awesome 5 Free";
    content: "\{{expanded_font_awesome}}";
    font-weight: 900;
    line-height:1em;
  	display: inline-flex;
}

{% if hover_effect == "underline" %}
	#{{uc_id}} a.uc-mega_menu_title:hover:after {
    content: "";
    bottom: 0;
    height: 3px;
    width: 100%;
    left: 0;
    background-color: {{pointer_color}};
    z-index: 2;
    position:absolute;
    }  
{% endif %}	

{% if hover_effect == "overline" %}
#{{uc_id}} a.uc-mega_menu_title:hover:before {
    content: "";
    top: 0;
    height: 3px;
    width: 100%;
    left: 0;
    background-color: {{pointer_color}};
    z-index: 2;
    position:absolute;
}
{% endif %}

{% if hover_effect == "double" %}
#{{uc_id}} a.uc-mega_menu_title:hover:after {
    content: "";
    bottom: 0;
    height: 3px;
    width: 100%;
    left: 0;
    background-color: {{pointer_color}};
    z-index: 2;
    position:absolute;
}  

#{{uc_id}} a.uc-mega_menu_title:hover:before {
    content: "";
    top: 0;
    height: 3px;
    width: 100%;
    left: 0;
    background-color: {{pointer_color}};
    z-index: 2;
    position:absolute;
}
{% endif %}

{% if hover_effect == "framed" %}
  #{{uc_id}} a.uc-mega_menu_title:hover:before {
      content: "";
      top: 0;
      bottom:0;
      left:0;
      right:0;
      height: 100%;
      width: 100%;
      border-style:solid;
      border-width:3px;
      border-color:{{pointer_color}};
      z-index: 2;
      position:absolute;
  }
{% endif %}

#{{uc_id}} .uc-mega_menu-burger, 
#{{uc_id}} .uc-mega_menu-close-btn  {
    display: none;
}

 #{{uc_id}} .uc-mega_menu-burger-icon, #{{uc_id}} .uc-mega_menu-close-btn-icon
{
  cursor: pointer;
  display: inline-flex;
  align-items: center;
  justify-content: center;
}

#{{uc_id}} .uc-mega_menu_section > *{
	position: relative;
  	z-index: 999997;
}

#{{uc_id}} .ue-tip{
	position: absolute;
  	width: 0;
  	height: 0;
  	border: 10px solid;
  	border-right-color: transparent;
  	border-bottom-color: transparent;
  	top: 0;
  	left: 50%;
  	transform: translate(-50%, -50%) rotate(45deg);
  	border-top-left-radius: 4px;
  	opacity: 0;
    z-index: 99996;
}

#{{uc_id}} .ue-graphic-element{
  display:inline-flex;
  align-items:center;
  justify-content:center;
  line-height:1em;
  overflow:hidden;
  flex-grow:0;
  flex-shrink:0;
  transition:0.3s;
}

#{{uc_id}} .ue-graphic-element svg{
  height:1em;
  width:1em;
  transition:0.3s;
}

#{{uc_id}} .ue-graphic-element img{
  display:block;
}

#{{uc_id}} .ue-ge-image{
  width:100%;
  transition:0.3s;
}

#{{uc_id}} .uc-mega_menu_section.uc-active_item .ue-tip{
  	opacity: 1;
}

#{{uc_id}} .uc-mega_menu-mobile-header{
  display:flex;
  justify-content:space-between;
  align-items:center;
}

#{{uc_id}} .uc-mega_menu-mobile-logo{
  flex-shrink:0;
  flex-grow:0;
  display:none;
}

#{{uc_id}} .uc-mega_menu-mobile-logo img{
  width:100%;
  display:block;
  object-fit:contain;
}

#{{uc_id}} .uc-mega_menu-close-btn{
  flex-grow:1;
}

/* start open transition animations */
{% if open_transition == "no" %}
  #{{uc_id}} .uc-mega_menu_section > *{
    opacity: 0;
    transition: none;
  }
  #{{uc_id}} .uc-mega_menu_section.uc-active_item > *{
	opacity: 1;
  }
{% endif %}

{% if open_transition == "slide_from_left" %}
  #{{uc_id}} .uc-mega_menu_section > *{
	transform: translate(-100%, 0);
    transition: transform {{open_transition_speed}}ms;
  }
  #{{uc_id}} .uc-mega_menu_section.uc-active_item > *{
	transform: translate(0, 0);
  }
{% endif %}

{% if open_transition == "slide_from_top" %}
  #{{uc_id}} .uc-mega_menu_section > *{
	transform: translate(0, calc(-100% - {{offset_y}}px));
    transition: transform {{open_transition_speed}}ms;
  }
  #{{uc_id}} .uc-mega_menu_section.uc-active_item > *{
	transform: translate(0, 0);
  }
{% endif %}

{% if open_transition == "slide_from_right" %}
  #{{uc_id}} .uc-mega_menu_section > *{
	transform: translate(100%, 0);
    transition: transform {{open_transition_speed}}ms;
  }
  #{{uc_id}} .uc-mega_menu_section.uc-active_item > *{
	transform: translate(0, 0);
  }
{% endif %}

{% if open_transition == "slide_from_bottom" %}
  #{{uc_id}} .uc-mega_menu_section > *{
	transform: translate(0, calc(100% + {{offset_y}}px));
    transition: transform {{open_transition_speed}}ms;
  }
  #{{uc_id}} .uc-mega_menu_section.uc-active_item > *{
	transform: translate(0, 0);
  }
{% endif %}

{% if open_transition == "fade_in" %}
  #{{uc_id}} .uc-mega_menu_section > *{
	opacity: 0;
    transition: opacity {{open_transition_speed}}ms;
  }
  #{{uc_id}} .uc-mega_menu_section.uc-active_item > *{
	opacity: 1;
  }
{% endif %}

{% if open_transition == "fade_in_left" %}
  #{{uc_id}} .uc-mega_menu_section > *{
	transform: translate(-15px, 0);
    opacity: 0;
    transition: transform {{open_transition_speed}}ms, opacity {{open_transition_speed}}ms;
  }
  #{{uc_id}} .uc-mega_menu_section.uc-active_item > *{
	transform: translate(0, 0);
    opacity: 1;
  }
{% endif %}

{% if open_transition == "fade_in_top" %}
  #{{uc_id}} .uc-mega_menu_section > *{
	transform: translate(0, -15px);
    opacity: 0;
    transition: transform {{open_transition_speed}}ms, opacity {{open_transition_speed}}ms;
  }
  #{{uc_id}} .uc-mega_menu_section.uc-active_item > *{
	transform: translate(0, 0);
    opacity: 1;
  }
{% endif %}

{% if open_transition == "fade_in_right" %}
  #{{uc_id}} .uc-mega_menu_section > *{
	transform: translate(15px, 0);
    opacity: 0;
    transition: transform {{open_transition_speed}}ms, opacity {{open_transition_speed}}ms;
  }
  #{{uc_id}} .uc-mega_menu_section.uc-active_item > *{
	transform: translate(0, 0);
    opacity: 1;
  }
{% endif %}

{% if open_transition == "fade_in_bottom" %}
  #{{uc_id}} .uc-mega_menu_section > *{
	transform: translate(0, 15px);
    opacity: 0;
    transition: transform {{open_transition_speed}}ms, opacity {{open_transition_speed}}ms;
  }
  #{{uc_id}} .uc-mega_menu_section.uc-active_item > *{
	transform: translate(0, 0);
    opacity: 1;
  }
{% endif %}
/* end open transition animation */

#{{uc_id}} .ue-mega-menu-mobile-template{
  display:none;
}

#{{uc_id}} .sub-arrow.uc-arrow-hidden{
  display:none;
}

@media screen and (max-width: {{responsive_mode_breakpoint}}px) {  
  
  #{{uc_id}} .ue-mega-menu-mobile-template{
  display:block;
  }
  
  #{{uc_id}} .uc-mega_menu-burger{
      display: block;
  }
  
  #{{uc_id}} .uc-mega_menu-close-btn{
	  display: block;
  }  
  
  #{{uc_id}} .uc-mega_menu-mobile-logo{
	  display: block;
  }
  
  #{{uc_id}} .uc-mega_menu-wrapper{
    position: fixed;
    transform: translate(-120%, 0);
    background-color: {{responive_mode_background}};
    width: 100%;
    overflow-y: auto;
    transition: all 0.3s;
  }
  
  #{{uc_id}} .uc-mega_menu_list{
  	flex-direction: column;
    max-width: 100%;
  }
  
  #{{uc_id}} .uc-mega_menu_section{
    top: 0 !important;
	width: 100% !important;
    left: 0 !important;
    padding-top: 0 !important;
    transform: translate(0, 0) !important;
  }
  
  #{{uc_id}} .uc-mega_menu_list_item{
    position: static !important;
  }
  
  #{{uc_id}} .uc-mega_menu_list_item.uc-active_item .uc-mega_menu_title{
  	position: sticky;
    top: 0;
    left: 0;
    z-index: 99999;
  }
  
  #{{uc_id}} .uc-mega_menu_list_item.uc-active_item .uc-mega_menu_title::before{
  	content: "";
    position: absolute;
    width: 100%;
    height: 100%;
    left: 0;
    top: 0;
    background-color: #ffffff;
    z-index: -1;
  }
  
  #{{uc_id}} .uc_mega_menu_overlay{
  	opacity: 0;
    display: none !important;
  }
  
  #{{uc_id}} .uc-mega_menu_section > *{
	transform: translate(0, 0) !important;
    opacity: 0;
    transition: transform {{open_transition_speed}}ms, opacity {{open_transition_speed}}ms;
  }
  
  #{{uc_id}} .uc-mega_menu_section.uc-active_item > *{
    opacity: 1;
  }
  
  #{{uc_id}} .uc-mobile-mode{
  	z-index: 99998;
  }
  
  #{{uc_id}} .ue-tip{
  	display: none;
  }
  
  #{{uc_id}} .uc-mega_menu_section-cover{
  	display: none;
  }

}