{# documentation for the slider library used: https://refreshless.com/nouislider/ #}

{{ ucfunc("put_docready_start") }}
  
  var objPriceRangeSlider = jQuery("#{{uc_id}}");
 
  var waitForLoadClass = "uc-waitforload";
  var ueRangeSliderSelector = ".ue-price-range-slider-element";
  var uePriceRangeSliderNumInputMinSelector = ".ue-price-range-slider_num_input-min";
  var uePriceRangeSliderNumInputMaxSelector = ".ue-price-range-slider_num_input-max";
  var uePriceRangeSliderResetButtonSelector = ".ue-price-range-slider-reset-button";
 
  var ue_range_slider, objMinInput, objMaxInput, objResetButton;  
 
  var isFilterInited = false;
  var objSlider;
 
  //options
  var minimumValue = {{minimum_value}};
  var maximumValue = {{maximum_value}};
  var minimumDefaultRangeValue = {% if minimum_default_range == "" %}""{% else %}{{minimum_default_range}}{% endif %};
  var maximimDefaultRangeValue = {% if maximum_default_range == "" %}""{% else %}{{maximum_default_range}}{% endif %};
  var minimumDefaultRange = {% if minimum_default_range == "" %}minimumValue{% else %}minimumDefaultRangeValue{% endif %};
  var maximumDefaultRange = {% if maximum_default_range == "" %}maximumValue{% else %}maximimDefaultRangeValue{% endif %};    
  var sliderBehaviour = {% if behavior is empty %}""{% else %}'{% for value in behavior %}{{value}}{% if not loop.last %}-{% endif %}{% endfor %}'{% endif %};
  var charNumAfterComa = {% if range_input_char_num is empty %}0{% else %}{{range_input_char_num}}{% endif %};
 
  var sliderOptions = {
     start: [minimumDefaultRange, maximumDefaultRange],
     connect: true,
     direction: '{{direction}}',
     step: {{step}},
     range: {
         'min': minimumValue,
         'max': maximumValue
       },
     {% if margin is not empty %}
       margin: {{margin}},
     {% endif %}
     {% if show_tooltip_values == "true" %} 
       tooltips: { 
         to: function(value) { 
    		var prefixElem = {% if show_prefix == "true" %}'<span class="ue-range-tooltip-prefix">{{prefix|raw}}</span>'{% else %}""{% endif %};
            var sufixElem =  {% if show_suffix == "true" %}'<span class="ue-range-tooltip-suffix">{{suffix|raw}}</span>'{% else %}""{% endif %};                                                                                                       	
    	    var tooltipElem = prefixElem + value + sufixElem;
            
    	    return(tooltipElem); 
         } 
       },
     {% endif %}
     {% if behavior is not empty %}
       behaviour: '{% for value in behavior %}{{value}}{% if not loop.last %}-{% endif %}{% endfor %}',
     {% endif %}
  }    
      
  /**
  * init vars
  */
  function initVars(){
  	ue_range_slider = objPriceRangeSlider.find(ueRangeSliderSelector)[0];
    objMinInput = objPriceRangeSlider.find(uePriceRangeSliderNumInputMinSelector);
    objMaxInput = objPriceRangeSlider.find(uePriceRangeSliderNumInputMaxSelector);
    objResetButton = objPriceRangeSlider.find(uePriceRangeSliderResetButtonSelector);
  }    
 
  /**
  * get value
  */
  function getValue(objInput){
  	var value = objInput.val();
    return(value);    
  }      
       
  /**
  * set slider values
  */
  function setSliderValues(val1, val2){
  	objSlider.set([val1, val2]);
  }    
 
  /**
  * min input change
  */
  function onMinInputChange(){
  	var value = getValue(objMinInput);
    setSliderValues(value, null);
  }
 
  /**
  * min input change
  */
  function onMaxInputChange(){
  	var value = getValue(objMaxInput);
    setSliderValues(null, value);
  }
      
  /**
  * get slider values
  */  
  function getSliderValues(){
  	var sliderValues = objSlider.get(true);
    return(sliderValues);
  }
 
  /**
  * get slider min value
  */
  function getSliderMinValue(){
    var sliderData = getSliderValues();
    var valueMin = sliderData[0];    
    return(valueMin);
  }
 
  /**
  * get slider max value
  */
  function getSliderMaxValue(){
    var sliderData = getSliderValues();
    var valueMax = sliderData[1];
    return(valueMax);
  }
 
  /**
  * on get filter data
  */
  function onGetFilterData(event, responseData){
    var valueMin = getSliderMinValue();
    var valueMax = getSliderMaxValue();

    var objOutput = {};
    
    objOutput["price_from"] = valueMin;
    objOutput["price_to"] = valueMax;
    
    responseData.output = objOutput; 
  }
 
  /**
  * on filter init
  */
  function onFilterInit(){
  	isFilterInited = true;  
  }
        
  /**
  * get lower handle obj
  */
  function getObjHandleLower(){
  	var objHandleLower = objPriceRangeSlider.find(".noUi-handle-lower");
    return(objHandleLower);
  } 
      
  /**
  * get upper handle obj
  */
  function getObjHandleUpper(){
  	var objHandleUpper = objPriceRangeSlider.find(".noUi-handle-upper");
    return(objHandleUpper);
  }       
      
  /**
  * default slider behaviour slider update
  */
  function setDefaultMinMaxValues(){      
    setSliderValues(minimumValue, maximumValue);
  }    
 
  /**
  * on slider update
  */
  function onSliderUpdate(){    
    var valueMin = getSliderMinValue();
    var valueMax = getSliderMaxValue();

    if(objMinInput && objMinInput.length > 0)
    objMinInput.val(valueMin.toFixed(charNumAfterComa));
        
    if(objMaxInput && objMaxInput.length > 0)
    objMaxInput.val(valueMax.toFixed(charNumAfterComa));    
     
    //trigger filter change     
    if(isFilterInited == true){
       
      g_ucDynamicFilters.runWithTrashold(function(){
      	objPriceRangeSlider.trigger("uc_filter_change",{refresh:false});
      },300);       
    }  
  }  
      
  /**
  * click on reset button
  */
  function onResetButtonClick(){  
    setDefaultMinMaxValues();
  }     
      
  /**    
  * on clear filter event
  */
  function onClearFilter(){
  	setDefaultMinMaxValues();
  }   
      
  /**
  * init events
  */
  function initLocalEvents(){
    //init events    
    objMinInput.on("change", onMinInputChange);
    objMaxInput.on("change", onMaxInputChange);    
    objSlider.on('update', onSliderUpdate);
    objResetButton.on("click", onResetButtonClick);
  }      
      
  /**
  * init global events
  */
  function initGlobalEvents(){
    objPriceRangeSlider.on("get_filter_data", onGetFilterData);
    objPriceRangeSlider.on("init_filter", onFilterInit);
    
    //additional filter events:  
    objPriceRangeSlider.on("clear_filter", onClearFilter); 
  }    
       
  /**
  * init noUiSlider 
  */
  function initSlider(){    
    //init vars    
 	initVars(); 
    
  	objSlider = noUiSlider.create(ue_range_slider, sliderOptions);    
    
    objPriceRangeSlider.removeClass(waitForLoadClass);
  }                       
      
  //init slider    
  initSlider();    

  //init events
  initLocalEvents();
  initGlobalEvents();    
      

{{ ucfunc("put_docready_end") }}